/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about agents or connectors that were instructed to start collecting data. Information includes the
 * agent/connector ID, a description of the operation, and whether the agent/connector configuration was updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentConfigurationStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentConfigurationStatus.Builder, AgentConfigurationStatus> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AgentConfigurationStatus::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<Boolean> OPERATION_SUCCEEDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AgentConfigurationStatus::operationSucceeded)).setter(setter(Builder::operationSucceeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationSucceeded").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AgentConfigurationStatus::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            OPERATION_SUCCEEDED_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final Boolean operationSucceeded;

    private final String description;

    private AgentConfigurationStatus(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.operationSucceeded = builder.operationSucceeded;
        this.description = builder.description;
    }

    /**
     * <p>
     * The agent/connector ID.
     * </p>
     * 
     * @return The agent/connector ID.
     */
    public String agentId() {
        return agentId;
    }

    /**
     * <p>
     * Information about the status of the <code>StartDataCollection</code> and <code>StopDataCollection</code>
     * operations. The system has recorded the data collection operation. The agent/connector receives this command the
     * next time it polls for a new command.
     * </p>
     * 
     * @return Information about the status of the <code>StartDataCollection</code> and <code>StopDataCollection</code>
     *         operations. The system has recorded the data collection operation. The agent/connector receives this
     *         command the next time it polls for a new command.
     */
    public Boolean operationSucceeded() {
        return operationSucceeded;
    }

    /**
     * <p>
     * A description of the operation performed.
     * </p>
     * 
     * @return A description of the operation performed.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(operationSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentConfigurationStatus)) {
            return false;
        }
        AgentConfigurationStatus other = (AgentConfigurationStatus) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(operationSucceeded(), other.operationSucceeded())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AgentConfigurationStatus").add("AgentId", agentId())
                .add("OperationSucceeded", operationSucceeded()).add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "operationSucceeded":
            return Optional.ofNullable(clazz.cast(operationSucceeded()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentConfigurationStatus, T> g) {
        return obj -> g.apply((AgentConfigurationStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentConfigurationStatus> {
        /**
         * <p>
         * The agent/connector ID.
         * </p>
         * 
         * @param agentId
         *        The agent/connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * Information about the status of the <code>StartDataCollection</code> and <code>StopDataCollection</code>
         * operations. The system has recorded the data collection operation. The agent/connector receives this command
         * the next time it polls for a new command.
         * </p>
         * 
         * @param operationSucceeded
         *        Information about the status of the <code>StartDataCollection</code> and
         *        <code>StopDataCollection</code> operations. The system has recorded the data collection operation. The
         *        agent/connector receives this command the next time it polls for a new command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationSucceeded(Boolean operationSucceeded);

        /**
         * <p>
         * A description of the operation performed.
         * </p>
         * 
         * @param description
         *        A description of the operation performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private Boolean operationSucceeded;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentConfigurationStatus model) {
            agentId(model.agentId);
            operationSucceeded(model.operationSucceeded);
            description(model.description);
        }

        public final String getAgentId() {
            return agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        public final Boolean getOperationSucceeded() {
            return operationSucceeded;
        }

        @Override
        public final Builder operationSucceeded(Boolean operationSucceeded) {
            this.operationSucceeded = operationSucceeded;
            return this;
        }

        public final void setOperationSucceeded(Boolean operationSucceeded) {
            this.operationSucceeded = operationSucceeded;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public AgentConfigurationStatus build() {
            return new AgentConfigurationStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
