/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsClient;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsResponse;

public class ListLogPatternSetsIterable
implements SdkIterable<ListLogPatternSetsResponse> {
    private final ApplicationInsightsClient client;
    private final ListLogPatternSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLogPatternSetsIterable(ApplicationInsightsClient client, ListLogPatternSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLogPatternSetsResponseFetcher();
    }

    public Iterator<ListLogPatternSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLogPatternSetsResponseFetcher
    implements SyncPageFetcher<ListLogPatternSetsResponse> {
        private ListLogPatternSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListLogPatternSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLogPatternSetsResponse nextPage(ListLogPatternSetsResponse previousPage) {
            if (previousPage == null) {
                return ListLogPatternSetsIterable.this.client.listLogPatternSets(ListLogPatternSetsIterable.this.firstRequest);
            }
            return ListLogPatternSetsIterable.this.client.listLogPatternSets((ListLogPatternSetsRequest)((Object)ListLogPatternSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

