/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsAsyncClient;
import software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse;

public class ListProblemsPublisher
implements SdkPublisher<ListProblemsResponse> {
    private final ApplicationInsightsAsyncClient client;
    private final ListProblemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProblemsPublisher(ApplicationInsightsAsyncClient client, ListProblemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProblemsPublisher(ApplicationInsightsAsyncClient client, ListProblemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProblemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProblemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProblemsResponseFetcher
    implements AsyncPageFetcher<ListProblemsResponse> {
        private ListProblemsResponseFetcher() {
        }

        public boolean hasNextPage(ListProblemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProblemsResponse> nextPage(ListProblemsResponse previousPage) {
            if (previousPage == null) {
                return ListProblemsPublisher.this.client.listProblems(ListProblemsPublisher.this.firstRequest);
            }
            return ListProblemsPublisher.this.client.listProblems((ListProblemsRequest)((Object)ListProblemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

