/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetNamedQueryRequest extends AthenaRequest implements
        ToCopyableBuilder<BatchGetNamedQueryRequest.Builder, BatchGetNamedQueryRequest> {
    private static final SdkField<List<String>> NAMED_QUERY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NamedQueryIds")
            .getter(getter(BatchGetNamedQueryRequest::namedQueryIds))
            .setter(setter(Builder::namedQueryIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueryIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERY_IDS_FIELD));

    private final List<String> namedQueryIds;

    private BatchGetNamedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.namedQueryIds = builder.namedQueryIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the NamedQueryIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNamedQueryIds() {
        return namedQueryIds != null && !(namedQueryIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of query IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNamedQueryIds} method.
     * </p>
     * 
     * @return An array of query IDs.
     */
    public final List<String> namedQueryIds() {
        return namedQueryIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNamedQueryIds() ? namedQueryIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetNamedQueryRequest)) {
            return false;
        }
        BatchGetNamedQueryRequest other = (BatchGetNamedQueryRequest) obj;
        return hasNamedQueryIds() == other.hasNamedQueryIds() && Objects.equals(namedQueryIds(), other.namedQueryIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetNamedQueryRequest").add("NamedQueryIds", hasNamedQueryIds() ? namedQueryIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamedQueryIds":
            return Optional.ofNullable(clazz.cast(namedQueryIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetNamedQueryRequest, T> g) {
        return obj -> g.apply((BatchGetNamedQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetNamedQueryRequest> {
        /**
         * <p>
         * An array of query IDs.
         * </p>
         * 
         * @param namedQueryIds
         *        An array of query IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQueryIds(Collection<String> namedQueryIds);

        /**
         * <p>
         * An array of query IDs.
         * </p>
         * 
         * @param namedQueryIds
         *        An array of query IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQueryIds(String... namedQueryIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private List<String> namedQueryIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetNamedQueryRequest model) {
            super(model);
            namedQueryIds(model.namedQueryIds);
        }

        public final Collection<String> getNamedQueryIds() {
            if (namedQueryIds instanceof SdkAutoConstructList) {
                return null;
            }
            return namedQueryIds;
        }

        public final void setNamedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
        }

        @Override
        public final Builder namedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueryIds(String... namedQueryIds) {
            namedQueryIds(Arrays.asList(namedQueryIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetNamedQueryRequest build() {
            return new BatchGetNamedQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
