/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where
 * query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch
 * Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data
 * usage limit for the amount of bytes scanned per query, if it is specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkGroupConfigurationUpdates implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkGroupConfigurationUpdates.Builder, WorkGroupConfigurationUpdates> {
    private static final SdkField<Boolean> ENFORCE_WORK_GROUP_CONFIGURATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnforceWorkGroupConfiguration")
            .getter(getter(WorkGroupConfigurationUpdates::enforceWorkGroupConfiguration))
            .setter(setter(Builder::enforceWorkGroupConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceWorkGroupConfiguration")
                    .build()).build();

    private static final SdkField<ResultConfigurationUpdates> RESULT_CONFIGURATION_UPDATES_FIELD = SdkField
            .<ResultConfigurationUpdates> builder(MarshallingType.SDK_POJO)
            .memberName("ResultConfigurationUpdates")
            .getter(getter(WorkGroupConfigurationUpdates::resultConfigurationUpdates))
            .setter(setter(Builder::resultConfigurationUpdates))
            .constructor(ResultConfigurationUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultConfigurationUpdates").build())
            .build();

    private static final SdkField<Boolean> PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PublishCloudWatchMetricsEnabled")
            .getter(getter(WorkGroupConfigurationUpdates::publishCloudWatchMetricsEnabled))
            .setter(setter(Builder::publishCloudWatchMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishCloudWatchMetricsEnabled")
                    .build()).build();

    private static final SdkField<Long> BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("BytesScannedCutoffPerQuery")
            .getter(getter(WorkGroupConfigurationUpdates::bytesScannedCutoffPerQuery))
            .setter(setter(Builder::bytesScannedCutoffPerQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesScannedCutoffPerQuery").build())
            .build();

    private static final SdkField<Boolean> REMOVE_BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveBytesScannedCutoffPerQuery")
            .getter(getter(WorkGroupConfigurationUpdates::removeBytesScannedCutoffPerQuery))
            .setter(setter(Builder::removeBytesScannedCutoffPerQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveBytesScannedCutoffPerQuery")
                    .build()).build();

    private static final SdkField<Boolean> REQUESTER_PAYS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequesterPaysEnabled").getter(getter(WorkGroupConfigurationUpdates::requesterPaysEnabled))
            .setter(setter(Builder::requesterPaysEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPaysEnabled").build())
            .build();

    private static final SdkField<EngineVersion> ENGINE_VERSION_FIELD = SdkField
            .<EngineVersion> builder(MarshallingType.SDK_POJO).memberName("EngineVersion")
            .getter(getter(WorkGroupConfigurationUpdates::engineVersion)).setter(setter(Builder::engineVersion))
            .constructor(EngineVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENFORCE_WORK_GROUP_CONFIGURATION_FIELD, RESULT_CONFIGURATION_UPDATES_FIELD,
            PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD, BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD,
            REMOVE_BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD, REQUESTER_PAYS_ENABLED_FIELD, ENGINE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enforceWorkGroupConfiguration;

    private final ResultConfigurationUpdates resultConfigurationUpdates;

    private final Boolean publishCloudWatchMetricsEnabled;

    private final Long bytesScannedCutoffPerQuery;

    private final Boolean removeBytesScannedCutoffPerQuery;

    private final Boolean requesterPaysEnabled;

    private final EngineVersion engineVersion;

    private WorkGroupConfigurationUpdates(BuilderImpl builder) {
        this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
        this.resultConfigurationUpdates = builder.resultConfigurationUpdates;
        this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
        this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
        this.removeBytesScannedCutoffPerQuery = builder.removeBytesScannedCutoffPerQuery;
        this.requesterPaysEnabled = builder.requesterPaysEnabled;
        this.engineVersion = builder.engineVersion;
    }

    /**
     * <p>
     * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side
     * settings are used. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
     * Client-Side Settings</a>.
     * </p>
     * 
     * @return If set to "true", the settings for the workgroup override client-side settings. If set to "false"
     *         client-side settings are used. For more information, see <a
     *         href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
     *         Override Client-Side Settings</a>.
     */
    public final Boolean enforceWorkGroupConfiguration() {
        return enforceWorkGroupConfiguration;
    }

    /**
     * <p>
     * The result configuration information about the queries in this workgroup that will be updated. Includes the
     * updated results location and an updated option for encrypting query results.
     * </p>
     * 
     * @return The result configuration information about the queries in this workgroup that will be updated. Includes
     *         the updated results location and an updated option for encrypting query results.
     */
    public final ResultConfigurationUpdates resultConfigurationUpdates() {
        return resultConfigurationUpdates;
    }

    /**
     * <p>
     * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     * </p>
     * 
     * @return Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     */
    public final Boolean publishCloudWatchMetricsEnabled() {
        return publishCloudWatchMetricsEnabled;
    }

    /**
     * <p>
     * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     * </p>
     * 
     * @return The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     */
    public final Long bytesScannedCutoffPerQuery() {
        return bytesScannedCutoffPerQuery;
    }

    /**
     * <p>
     * Indicates that the data usage control limit per query is removed.
     * <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     * </p>
     * 
     * @return Indicates that the data usage control limit per query is removed.
     *         <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     */
    public final Boolean removeBytesScannedCutoffPerQuery() {
        return removeBytesScannedCutoffPerQuery;
    }

    /**
     * <p>
     * If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets
     * in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and
     * queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For
     * more information about Requester Pays buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in
     * the <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * 
     * @return If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays
     *         buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays
     *         buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is
     *         <code>false</code>. For more information about Requester Pays buckets, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays
     *         Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
     */
    public final Boolean requesterPaysEnabled() {
        return requesterPaysEnabled;
    }

    /**
     * <p>
     * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on
     * the requested engine version. If no value was previously set, the default is Auto. Queries on the
     * <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
     * </p>
     * 
     * @return The engine version requested when a workgroup is updated. After the update, all queries on the workgroup
     *         run on the requested engine version. If no value was previously set, the default is Auto. Queries on the
     *         <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this
     *         setting.
     */
    public final EngineVersion engineVersion() {
        return engineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enforceWorkGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(resultConfigurationUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(publishCloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(bytesScannedCutoffPerQuery());
        hashCode = 31 * hashCode + Objects.hashCode(removeBytesScannedCutoffPerQuery());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPaysEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkGroupConfigurationUpdates)) {
            return false;
        }
        WorkGroupConfigurationUpdates other = (WorkGroupConfigurationUpdates) obj;
        return Objects.equals(enforceWorkGroupConfiguration(), other.enforceWorkGroupConfiguration())
                && Objects.equals(resultConfigurationUpdates(), other.resultConfigurationUpdates())
                && Objects.equals(publishCloudWatchMetricsEnabled(), other.publishCloudWatchMetricsEnabled())
                && Objects.equals(bytesScannedCutoffPerQuery(), other.bytesScannedCutoffPerQuery())
                && Objects.equals(removeBytesScannedCutoffPerQuery(), other.removeBytesScannedCutoffPerQuery())
                && Objects.equals(requesterPaysEnabled(), other.requesterPaysEnabled())
                && Objects.equals(engineVersion(), other.engineVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkGroupConfigurationUpdates")
                .add("EnforceWorkGroupConfiguration", enforceWorkGroupConfiguration())
                .add("ResultConfigurationUpdates", resultConfigurationUpdates())
                .add("PublishCloudWatchMetricsEnabled", publishCloudWatchMetricsEnabled())
                .add("BytesScannedCutoffPerQuery", bytesScannedCutoffPerQuery())
                .add("RemoveBytesScannedCutoffPerQuery", removeBytesScannedCutoffPerQuery())
                .add("RequesterPaysEnabled", requesterPaysEnabled()).add("EngineVersion", engineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnforceWorkGroupConfiguration":
            return Optional.ofNullable(clazz.cast(enforceWorkGroupConfiguration()));
        case "ResultConfigurationUpdates":
            return Optional.ofNullable(clazz.cast(resultConfigurationUpdates()));
        case "PublishCloudWatchMetricsEnabled":
            return Optional.ofNullable(clazz.cast(publishCloudWatchMetricsEnabled()));
        case "BytesScannedCutoffPerQuery":
            return Optional.ofNullable(clazz.cast(bytesScannedCutoffPerQuery()));
        case "RemoveBytesScannedCutoffPerQuery":
            return Optional.ofNullable(clazz.cast(removeBytesScannedCutoffPerQuery()));
        case "RequesterPaysEnabled":
            return Optional.ofNullable(clazz.cast(requesterPaysEnabled()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkGroupConfigurationUpdates, T> g) {
        return obj -> g.apply((WorkGroupConfigurationUpdates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkGroupConfigurationUpdates> {
        /**
         * <p>
         * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side
         * settings are used. For more information, see <a
         * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
         * Override Client-Side Settings</a>.
         * </p>
         * 
         * @param enforceWorkGroupConfiguration
         *        If set to "true", the settings for the workgroup override client-side settings. If set to "false"
         *        client-side settings are used. For more information, see <a
         *        href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup
         *        Settings Override Client-Side Settings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration);

        /**
         * <p>
         * The result configuration information about the queries in this workgroup that will be updated. Includes the
         * updated results location and an updated option for encrypting query results.
         * </p>
         * 
         * @param resultConfigurationUpdates
         *        The result configuration information about the queries in this workgroup that will be updated.
         *        Includes the updated results location and an updated option for encrypting query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultConfigurationUpdates(ResultConfigurationUpdates resultConfigurationUpdates);

        /**
         * <p>
         * The result configuration information about the queries in this workgroup that will be updated. Includes the
         * updated results location and an updated option for encrypting query results.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResultConfigurationUpdates.Builder}
         * avoiding the need to create one manually via {@link ResultConfigurationUpdates#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResultConfigurationUpdates.Builder#build()} is called immediately
         * and its result is passed to {@link #resultConfigurationUpdates(ResultConfigurationUpdates)}.
         * 
         * @param resultConfigurationUpdates
         *        a consumer that will call methods on {@link ResultConfigurationUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultConfigurationUpdates(ResultConfigurationUpdates)
         */
        default Builder resultConfigurationUpdates(Consumer<ResultConfigurationUpdates.Builder> resultConfigurationUpdates) {
            return resultConfigurationUpdates(ResultConfigurationUpdates.builder().applyMutation(resultConfigurationUpdates)
                    .build());
        }

        /**
         * <p>
         * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
         * </p>
         * 
         * @param publishCloudWatchMetricsEnabled
         *        Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled);

        /**
         * <p>
         * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         * </p>
         * 
         * @param bytesScannedCutoffPerQuery
         *        The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery);

        /**
         * <p>
         * Indicates that the data usage control limit per query is removed.
         * <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
         * </p>
         * 
         * @param removeBytesScannedCutoffPerQuery
         *        Indicates that the data usage control limit per query is removed.
         *        <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery);

        /**
         * <p>
         * If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays
         * buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays
         * buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is
         * <code>false</code>. For more information about Requester Pays buckets, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>
         * in the <i>Amazon Simple Storage Service Developer Guide</i>.
         * </p>
         * 
         * @param requesterPaysEnabled
         *        If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester
         *        Pays buckets in queries. If set to <code>false</code>, workgroup members cannot query data from
         *        Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The
         *        default is <code>false</code>. For more information about Requester Pays buckets, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays
         *        Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPaysEnabled(Boolean requesterPaysEnabled);

        /**
         * <p>
         * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run
         * on the requested engine version. If no value was previously set, the default is Auto. Queries on the
         * <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
         * </p>
         * 
         * @param engineVersion
         *        The engine version requested when a workgroup is updated. After the update, all queries on the
         *        workgroup run on the requested engine version. If no value was previously set, the default is Auto.
         *        Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine
         *        regardless of this setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(EngineVersion engineVersion);

        /**
         * <p>
         * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run
         * on the requested engine version. If no value was previously set, the default is Auto. Queries on the
         * <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link EngineVersion.Builder} avoiding the need
         * to create one manually via {@link EngineVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link EngineVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #engineVersion(EngineVersion)}.
         * 
         * @param engineVersion
         *        a consumer that will call methods on {@link EngineVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineVersion(EngineVersion)
         */
        default Builder engineVersion(Consumer<EngineVersion.Builder> engineVersion) {
            return engineVersion(EngineVersion.builder().applyMutation(engineVersion).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enforceWorkGroupConfiguration;

        private ResultConfigurationUpdates resultConfigurationUpdates;

        private Boolean publishCloudWatchMetricsEnabled;

        private Long bytesScannedCutoffPerQuery;

        private Boolean removeBytesScannedCutoffPerQuery;

        private Boolean requesterPaysEnabled;

        private EngineVersion engineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkGroupConfigurationUpdates model) {
            enforceWorkGroupConfiguration(model.enforceWorkGroupConfiguration);
            resultConfigurationUpdates(model.resultConfigurationUpdates);
            publishCloudWatchMetricsEnabled(model.publishCloudWatchMetricsEnabled);
            bytesScannedCutoffPerQuery(model.bytesScannedCutoffPerQuery);
            removeBytesScannedCutoffPerQuery(model.removeBytesScannedCutoffPerQuery);
            requesterPaysEnabled(model.requesterPaysEnabled);
            engineVersion(model.engineVersion);
        }

        public final Boolean getEnforceWorkGroupConfiguration() {
            return enforceWorkGroupConfiguration;
        }

        public final void setEnforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
        }

        @Override
        public final Builder enforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
            return this;
        }

        public final ResultConfigurationUpdates.Builder getResultConfigurationUpdates() {
            return resultConfigurationUpdates != null ? resultConfigurationUpdates.toBuilder() : null;
        }

        public final void setResultConfigurationUpdates(ResultConfigurationUpdates.BuilderImpl resultConfigurationUpdates) {
            this.resultConfigurationUpdates = resultConfigurationUpdates != null ? resultConfigurationUpdates.build() : null;
        }

        @Override
        public final Builder resultConfigurationUpdates(ResultConfigurationUpdates resultConfigurationUpdates) {
            this.resultConfigurationUpdates = resultConfigurationUpdates;
            return this;
        }

        public final Boolean getPublishCloudWatchMetricsEnabled() {
            return publishCloudWatchMetricsEnabled;
        }

        public final void setPublishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
        }

        @Override
        public final Builder publishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
            return this;
        }

        public final Long getBytesScannedCutoffPerQuery() {
            return bytesScannedCutoffPerQuery;
        }

        public final void setBytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
        }

        @Override
        public final Builder bytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
            return this;
        }

        public final Boolean getRemoveBytesScannedCutoffPerQuery() {
            return removeBytesScannedCutoffPerQuery;
        }

        public final void setRemoveBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery) {
            this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
        }

        @Override
        public final Builder removeBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery) {
            this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
            return this;
        }

        public final Boolean getRequesterPaysEnabled() {
            return requesterPaysEnabled;
        }

        public final void setRequesterPaysEnabled(Boolean requesterPaysEnabled) {
            this.requesterPaysEnabled = requesterPaysEnabled;
        }

        @Override
        public final Builder requesterPaysEnabled(Boolean requesterPaysEnabled) {
            this.requesterPaysEnabled = requesterPaysEnabled;
            return this;
        }

        public final EngineVersion.Builder getEngineVersion() {
            return engineVersion != null ? engineVersion.toBuilder() : null;
        }

        public final void setEngineVersion(EngineVersion.BuilderImpl engineVersion) {
            this.engineVersion = engineVersion != null ? engineVersion.build() : null;
        }

        @Override
        public final Builder engineVersion(EngineVersion engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        @Override
        public WorkGroupConfigurationUpdates build() {
            return new WorkGroupConfigurationUpdates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
