/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNamedQueryResponse extends AthenaResponse implements
        ToCopyableBuilder<GetNamedQueryResponse.Builder, GetNamedQueryResponse> {
    private static final SdkField<NamedQuery> NAMED_QUERY_FIELD = SdkField.<NamedQuery> builder(MarshallingType.SDK_POJO)
            .memberName("NamedQuery").getter(getter(GetNamedQueryResponse::namedQuery)).setter(setter(Builder::namedQuery))
            .constructor(NamedQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERY_FIELD));

    private final NamedQuery namedQuery;

    private GetNamedQueryResponse(BuilderImpl builder) {
        super(builder);
        this.namedQuery = builder.namedQuery;
    }

    /**
     * <p>
     * Information about the query.
     * </p>
     * 
     * @return Information about the query.
     */
    public final NamedQuery namedQuery() {
        return namedQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namedQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNamedQueryResponse)) {
            return false;
        }
        GetNamedQueryResponse other = (GetNamedQueryResponse) obj;
        return Objects.equals(namedQuery(), other.namedQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNamedQueryResponse").add("NamedQuery", namedQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamedQuery":
            return Optional.ofNullable(clazz.cast(namedQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNamedQueryResponse, T> g) {
        return obj -> g.apply((GetNamedQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetNamedQueryResponse> {
        /**
         * <p>
         * Information about the query.
         * </p>
         * 
         * @param namedQuery
         *        Information about the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQuery(NamedQuery namedQuery);

        /**
         * <p>
         * Information about the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link NamedQuery.Builder} avoiding the need to
         * create one manually via {@link NamedQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NamedQuery.Builder#build()} is called immediately and its result
         * is passed to {@link #namedQuery(NamedQuery)}.
         * 
         * @param namedQuery
         *        a consumer that will call methods on {@link NamedQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namedQuery(NamedQuery)
         */
        default Builder namedQuery(Consumer<NamedQuery.Builder> namedQuery) {
            return namedQuery(NamedQuery.builder().applyMutation(namedQuery).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private NamedQuery namedQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNamedQueryResponse model) {
            super(model);
            namedQuery(model.namedQuery);
        }

        public final NamedQuery.Builder getNamedQuery() {
            return namedQuery != null ? namedQuery.toBuilder() : null;
        }

        public final void setNamedQuery(NamedQuery.BuilderImpl namedQuery) {
            this.namedQuery = namedQuery != null ? namedQuery.build() : null;
        }

        @Override
        public final Builder namedQuery(NamedQuery namedQuery) {
            this.namedQuery = namedQuery;
            return this;
        }

        @Override
        public GetNamedQueryResponse build() {
            return new GetNamedQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
