/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePresignedNotebookUrlResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, CreatePresignedNotebookUrlResponse> {
    private static final SdkField<String> NOTEBOOK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookUrl").getter(CreatePresignedNotebookUrlResponse.getter(CreatePresignedNotebookUrlResponse::notebookUrl)).setter(CreatePresignedNotebookUrlResponse.setter(Builder::notebookUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookUrl").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthToken").getter(CreatePresignedNotebookUrlResponse.getter(CreatePresignedNotebookUrlResponse::authToken)).setter(CreatePresignedNotebookUrlResponse.setter(Builder::authToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()}).build();
    private static final SdkField<Long> AUTH_TOKEN_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AuthTokenExpirationTime").getter(CreatePresignedNotebookUrlResponse.getter(CreatePresignedNotebookUrlResponse::authTokenExpirationTime)).setter(CreatePresignedNotebookUrlResponse.setter(Builder::authTokenExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenExpirationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_URL_FIELD, AUTH_TOKEN_FIELD, AUTH_TOKEN_EXPIRATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePresignedNotebookUrlResponse.memberNameToFieldInitializer();
    private final String notebookUrl;
    private final String authToken;
    private final Long authTokenExpirationTime;

    private CreatePresignedNotebookUrlResponse(BuilderImpl builder) {
        super(builder);
        this.notebookUrl = builder.notebookUrl;
        this.authToken = builder.authToken;
        this.authTokenExpirationTime = builder.authTokenExpirationTime;
    }

    public final String notebookUrl() {
        return this.notebookUrl;
    }

    public final String authToken() {
        return this.authToken;
    }

    public final Long authTokenExpirationTime() {
        return this.authTokenExpirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.authToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenExpirationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedNotebookUrlResponse)) {
            return false;
        }
        CreatePresignedNotebookUrlResponse other = (CreatePresignedNotebookUrlResponse)((Object)obj);
        return Objects.equals(this.notebookUrl(), other.notebookUrl()) && Objects.equals(this.authToken(), other.authToken()) && Objects.equals(this.authTokenExpirationTime(), other.authTokenExpirationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePresignedNotebookUrlResponse").add("NotebookUrl", (Object)this.notebookUrl()).add("AuthToken", (Object)this.authToken()).add("AuthTokenExpirationTime", (Object)this.authTokenExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookUrl": {
                return Optional.ofNullable(clazz.cast(this.notebookUrl()));
            }
            case "AuthToken": {
                return Optional.ofNullable(clazz.cast(this.authToken()));
            }
            case "AuthTokenExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.authTokenExpirationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NotebookUrl", NOTEBOOK_URL_FIELD);
        map.put("AuthToken", AUTH_TOKEN_FIELD);
        map.put("AuthTokenExpirationTime", AUTH_TOKEN_EXPIRATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedNotebookUrlResponse, T> g) {
        return obj -> g.apply((CreatePresignedNotebookUrlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private String notebookUrl;
        private String authToken;
        private Long authTokenExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedNotebookUrlResponse model) {
            super(model);
            this.notebookUrl(model.notebookUrl);
            this.authToken(model.authToken);
            this.authTokenExpirationTime(model.authTokenExpirationTime);
        }

        public final String getNotebookUrl() {
            return this.notebookUrl;
        }

        public final void setNotebookUrl(String notebookUrl) {
            this.notebookUrl = notebookUrl;
        }

        @Override
        public final Builder notebookUrl(String notebookUrl) {
            this.notebookUrl = notebookUrl;
            return this;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final Long getAuthTokenExpirationTime() {
            return this.authTokenExpirationTime;
        }

        public final void setAuthTokenExpirationTime(Long authTokenExpirationTime) {
            this.authTokenExpirationTime = authTokenExpirationTime;
        }

        @Override
        public final Builder authTokenExpirationTime(Long authTokenExpirationTime) {
            this.authTokenExpirationTime = authTokenExpirationTime;
            return this;
        }

        @Override
        public CreatePresignedNotebookUrlResponse build() {
            return new CreatePresignedNotebookUrlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePresignedNotebookUrlResponse> {
        public Builder notebookUrl(String var1);

        public Builder authToken(String var1);

        public Builder authTokenExpirationTime(Long var1);
    }
}

