/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AclConfiguration;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultConfiguration> {
    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputLocation").getter(ResultConfiguration.getter(ResultConfiguration::outputLocation)).setter(ResultConfiguration.setter(Builder::outputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(ResultConfiguration.getter(ResultConfiguration::encryptionConfiguration)).setter(ResultConfiguration.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpectedBucketOwner").getter(ResultConfiguration.getter(ResultConfiguration::expectedBucketOwner)).setter(ResultConfiguration.setter(Builder::expectedBucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedBucketOwner").build()}).build();
    private static final SdkField<AclConfiguration> ACL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AclConfiguration").getter(ResultConfiguration.getter(ResultConfiguration::aclConfiguration)).setter(ResultConfiguration.setter(Builder::aclConfiguration)).constructor(AclConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AclConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_LOCATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, EXPECTED_BUCKET_OWNER_FIELD, ACL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResultConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outputLocation;
    private final EncryptionConfiguration encryptionConfiguration;
    private final String expectedBucketOwner;
    private final AclConfiguration aclConfiguration;

    private ResultConfiguration(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.aclConfiguration = builder.aclConfiguration;
    }

    public final String outputLocation() {
        return this.outputLocation;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public final AclConfiguration aclConfiguration() {
        return this.aclConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedBucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.aclConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultConfiguration)) {
            return false;
        }
        ResultConfiguration other = (ResultConfiguration)obj;
        return Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.expectedBucketOwner(), other.expectedBucketOwner()) && Objects.equals(this.aclConfiguration(), other.aclConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ResultConfiguration").add("OutputLocation", (Object)this.outputLocation()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("ExpectedBucketOwner", (Object)this.expectedBucketOwner()).add("AclConfiguration", (Object)this.aclConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "ExpectedBucketOwner": {
                return Optional.ofNullable(clazz.cast(this.expectedBucketOwner()));
            }
            case "AclConfiguration": {
                return Optional.ofNullable(clazz.cast(this.aclConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutputLocation", OUTPUT_LOCATION_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("ExpectedBucketOwner", EXPECTED_BUCKET_OWNER_FIELD);
        map.put("AclConfiguration", ACL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultConfiguration, T> g) {
        return obj -> g.apply((ResultConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputLocation;
        private EncryptionConfiguration encryptionConfiguration;
        private String expectedBucketOwner;
        private AclConfiguration aclConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultConfiguration model) {
            this.outputLocation(model.outputLocation);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.aclConfiguration(model.aclConfiguration);
        }

        public final String getOutputLocation() {
            return this.outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final String getExpectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public final AclConfiguration.Builder getAclConfiguration() {
            return this.aclConfiguration != null ? this.aclConfiguration.toBuilder() : null;
        }

        public final void setAclConfiguration(AclConfiguration.BuilderImpl aclConfiguration) {
            this.aclConfiguration = aclConfiguration != null ? aclConfiguration.build() : null;
        }

        @Override
        public final Builder aclConfiguration(AclConfiguration aclConfiguration) {
            this.aclConfiguration = aclConfiguration;
            return this;
        }

        public ResultConfiguration build() {
            return new ResultConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultConfiguration> {
        public Builder outputLocation(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder expectedBucketOwner(String var1);

        public Builder aclConfiguration(AclConfiguration var1);

        default public Builder aclConfiguration(Consumer<AclConfiguration.Builder> aclConfiguration) {
            return this.aclConfiguration((AclConfiguration)((AclConfiguration.Builder)AclConfiguration.builder().applyMutation(aclConfiguration)).build());
        }
    }
}

