/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.ResultSet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryResultsResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, GetQueryResultsResponse> {
    private static final SdkField<Long> UPDATE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("UpdateCount").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::updateCount)).setter(GetQueryResultsResponse.setter(Builder::updateCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateCount").build()}).build();
    private static final SdkField<ResultSet> RESULT_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResultSet").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::resultSet)).setter(GetQueryResultsResponse.setter(Builder::resultSet)).constructor(ResultSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSet").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::nextToken)).setter(GetQueryResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_COUNT_FIELD, RESULT_SET_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQueryResultsResponse.memberNameToFieldInitializer();
    private final Long updateCount;
    private final ResultSet resultSet;
    private final String nextToken;

    private GetQueryResultsResponse(BuilderImpl builder) {
        super(builder);
        this.updateCount = builder.updateCount;
        this.resultSet = builder.resultSet;
        this.nextToken = builder.nextToken;
    }

    public final Long updateCount() {
        return this.updateCount;
    }

    public final ResultSet resultSet() {
        return this.resultSet;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.updateCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsResponse)) {
            return false;
        }
        GetQueryResultsResponse other = (GetQueryResultsResponse)((Object)obj);
        return Objects.equals(this.updateCount(), other.updateCount()) && Objects.equals(this.resultSet(), other.resultSet()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueryResultsResponse").add("UpdateCount", (Object)this.updateCount()).add("ResultSet", (Object)this.resultSet()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpdateCount": {
                return Optional.ofNullable(clazz.cast(this.updateCount()));
            }
            case "ResultSet": {
                return Optional.ofNullable(clazz.cast(this.resultSet()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UpdateCount", UPDATE_COUNT_FIELD);
        map.put("ResultSet", RESULT_SET_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private Long updateCount;
        private ResultSet resultSet;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsResponse model) {
            super(model);
            this.updateCount(model.updateCount);
            this.resultSet(model.resultSet);
            this.nextToken(model.nextToken);
        }

        public final Long getUpdateCount() {
            return this.updateCount;
        }

        public final void setUpdateCount(Long updateCount) {
            this.updateCount = updateCount;
        }

        @Override
        public final Builder updateCount(Long updateCount) {
            this.updateCount = updateCount;
            return this;
        }

        public final ResultSet.Builder getResultSet() {
            return this.resultSet != null ? this.resultSet.toBuilder() : null;
        }

        public final void setResultSet(ResultSet.BuilderImpl resultSet) {
            this.resultSet = resultSet != null ? resultSet.build() : null;
        }

        @Override
        public final Builder resultSet(ResultSet resultSet) {
            this.resultSet = resultSet;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetQueryResultsResponse build() {
            return new GetQueryResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryResultsResponse> {
        public Builder updateCount(Long var1);

        public Builder resultSet(ResultSet var1);

        default public Builder resultSet(Consumer<ResultSet.Builder> resultSet) {
            return this.resultSet((ResultSet)((ResultSet.Builder)ResultSet.builder().applyMutation(resultSet)).build());
        }

        public Builder nextToken(String var1);
    }
}

