/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.EngineConfiguration;
import software.amazon.awssdk.services.athena.model.SessionConfiguration;
import software.amazon.awssdk.services.athena.model.SessionStatistics;
import software.amazon.awssdk.services.athena.model.SessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, GetSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(GetSessionResponse.getter(GetSessionResponse::sessionId)).setter(GetSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetSessionResponse.getter(GetSessionResponse::description)).setter(GetSessionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(GetSessionResponse.getter(GetSessionResponse::workGroup)).setter(GetSessionResponse.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(GetSessionResponse.getter(GetSessionResponse::engineVersion)).setter(GetSessionResponse.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<EngineConfiguration> ENGINE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EngineConfiguration").getter(GetSessionResponse.getter(GetSessionResponse::engineConfiguration)).setter(GetSessionResponse.setter(Builder::engineConfiguration)).constructor(EngineConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineConfiguration").build()}).build();
    private static final SdkField<String> NOTEBOOK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookVersion").getter(GetSessionResponse.getter(GetSessionResponse::notebookVersion)).setter(GetSessionResponse.setter(Builder::notebookVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookVersion").build()}).build();
    private static final SdkField<SessionConfiguration> SESSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SessionConfiguration").getter(GetSessionResponse.getter(GetSessionResponse::sessionConfiguration)).setter(GetSessionResponse.setter(Builder::sessionConfiguration)).constructor(SessionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionConfiguration").build()}).build();
    private static final SdkField<SessionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(GetSessionResponse.getter(GetSessionResponse::status)).setter(GetSessionResponse.setter(Builder::status)).constructor(SessionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<SessionStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Statistics").getter(GetSessionResponse.getter(GetSessionResponse::statistics)).setter(GetSessionResponse.setter(Builder::statistics)).constructor(SessionStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, DESCRIPTION_FIELD, WORK_GROUP_FIELD, ENGINE_VERSION_FIELD, ENGINE_CONFIGURATION_FIELD, NOTEBOOK_VERSION_FIELD, SESSION_CONFIGURATION_FIELD, STATUS_FIELD, STATISTICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSessionResponse.memberNameToFieldInitializer();
    private final String sessionId;
    private final String description;
    private final String workGroup;
    private final String engineVersion;
    private final EngineConfiguration engineConfiguration;
    private final String notebookVersion;
    private final SessionConfiguration sessionConfiguration;
    private final SessionStatus status;
    private final SessionStatistics statistics;

    private GetSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.description = builder.description;
        this.workGroup = builder.workGroup;
        this.engineVersion = builder.engineVersion;
        this.engineConfiguration = builder.engineConfiguration;
        this.notebookVersion = builder.notebookVersion;
        this.sessionConfiguration = builder.sessionConfiguration;
        this.status = builder.status;
        this.statistics = builder.statistics;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String description() {
        return this.description;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final EngineConfiguration engineConfiguration() {
        return this.engineConfiguration;
    }

    public final String notebookVersion() {
        return this.notebookVersion;
    }

    public final SessionConfiguration sessionConfiguration() {
        return this.sessionConfiguration;
    }

    public final SessionStatus status() {
        return this.status;
    }

    public final SessionStatistics statistics() {
        return this.statistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponse)) {
            return false;
        }
        GetSessionResponse other = (GetSessionResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.workGroup(), other.workGroup()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.engineConfiguration(), other.engineConfiguration()) && Objects.equals(this.notebookVersion(), other.notebookVersion()) && Objects.equals(this.sessionConfiguration(), other.sessionConfiguration()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statistics(), other.statistics());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionResponse").add("SessionId", (Object)this.sessionId()).add("Description", (Object)this.description()).add("WorkGroup", (Object)this.workGroup()).add("EngineVersion", (Object)this.engineVersion()).add("EngineConfiguration", (Object)this.engineConfiguration()).add("NotebookVersion", (Object)this.notebookVersion()).add("SessionConfiguration", (Object)this.sessionConfiguration()).add("Status", (Object)this.status()).add("Statistics", (Object)this.statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "EngineConfiguration": {
                return Optional.ofNullable(clazz.cast(this.engineConfiguration()));
            }
            case "NotebookVersion": {
                return Optional.ofNullable(clazz.cast(this.notebookVersion()));
            }
            case "SessionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sessionConfiguration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("EngineConfiguration", ENGINE_CONFIGURATION_FIELD);
        map.put("NotebookVersion", NOTEBOOK_VERSION_FIELD);
        map.put("SessionConfiguration", SESSION_CONFIGURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Statistics", STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponse, T> g) {
        return obj -> g.apply((GetSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private String description;
        private String workGroup;
        private String engineVersion;
        private EngineConfiguration engineConfiguration;
        private String notebookVersion;
        private SessionConfiguration sessionConfiguration;
        private SessionStatus status;
        private SessionStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.description(model.description);
            this.workGroup(model.workGroup);
            this.engineVersion(model.engineVersion);
            this.engineConfiguration(model.engineConfiguration);
            this.notebookVersion(model.notebookVersion);
            this.sessionConfiguration(model.sessionConfiguration);
            this.status(model.status);
            this.statistics(model.statistics);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final EngineConfiguration.Builder getEngineConfiguration() {
            return this.engineConfiguration != null ? this.engineConfiguration.toBuilder() : null;
        }

        public final void setEngineConfiguration(EngineConfiguration.BuilderImpl engineConfiguration) {
            this.engineConfiguration = engineConfiguration != null ? engineConfiguration.build() : null;
        }

        @Override
        public final Builder engineConfiguration(EngineConfiguration engineConfiguration) {
            this.engineConfiguration = engineConfiguration;
            return this;
        }

        public final String getNotebookVersion() {
            return this.notebookVersion;
        }

        public final void setNotebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
        }

        @Override
        public final Builder notebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
            return this;
        }

        public final SessionConfiguration.Builder getSessionConfiguration() {
            return this.sessionConfiguration != null ? this.sessionConfiguration.toBuilder() : null;
        }

        public final void setSessionConfiguration(SessionConfiguration.BuilderImpl sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration != null ? sessionConfiguration.build() : null;
        }

        @Override
        public final Builder sessionConfiguration(SessionConfiguration sessionConfiguration) {
            this.sessionConfiguration = sessionConfiguration;
            return this;
        }

        public final SessionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(SessionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status = status;
            return this;
        }

        public final SessionStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(SessionStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(SessionStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public GetSessionResponse build() {
            return new GetSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionResponse> {
        public Builder sessionId(String var1);

        public Builder description(String var1);

        public Builder workGroup(String var1);

        public Builder engineVersion(String var1);

        public Builder engineConfiguration(EngineConfiguration var1);

        default public Builder engineConfiguration(Consumer<EngineConfiguration.Builder> engineConfiguration) {
            return this.engineConfiguration((EngineConfiguration)((EngineConfiguration.Builder)EngineConfiguration.builder().applyMutation(engineConfiguration)).build());
        }

        public Builder notebookVersion(String var1);

        public Builder sessionConfiguration(SessionConfiguration var1);

        default public Builder sessionConfiguration(Consumer<SessionConfiguration.Builder> sessionConfiguration) {
            return this.sessionConfiguration((SessionConfiguration)((SessionConfiguration.Builder)SessionConfiguration.builder().applyMutation(sessionConfiguration)).build());
        }

        public Builder status(SessionStatus var1);

        default public Builder status(Consumer<SessionStatus.Builder> status) {
            return this.status((SessionStatus)((SessionStatus.Builder)SessionStatus.builder().applyMutation(status)).build());
        }

        public Builder statistics(SessionStatistics var1);

        default public Builder statistics(Consumer<SessionStatistics.Builder> statistics) {
            return this.statistics((SessionStatistics)((SessionStatistics.Builder)SessionStatistics.builder().applyMutation(statistics)).build());
        }
    }
}

