/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListSessionsResponse;

public class ListSessionsIterable
implements SdkIterable<ListSessionsResponse> {
    private final AthenaClient client;
    private final ListSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSessionsIterable(AthenaClient client, ListSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSessionsResponseFetcher();
    }

    public Iterator<ListSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSessionsResponseFetcher
    implements SyncPageFetcher<ListSessionsResponse> {
        private ListSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSessionsResponse nextPage(ListSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListSessionsIterable.this.client.listSessions(ListSessionsIterable.this.firstRequest);
            }
            return ListSessionsIterable.this.client.listSessions((ListSessionsRequest)((Object)ListSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

