/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatementType {
    DDL("DDL"),
    DML("DML"),
    UTILITY("UTILITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatementType> VALUE_MAP;
    private final String value;

    private StatementType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatementType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatementType> knownValues() {
        EnumSet<StatementType> knownValues = EnumSet.allOf(StatementType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatementType.class, StatementType::toString);
    }
}

