/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials.internal;

import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ToString;

@SdkInternalApi
public class LazyAwsCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private final Supplier<AwsCredentialsProvider> delegateConstructor;
    private volatile AwsCredentialsProvider delegate;

    private LazyAwsCredentialsProvider(Supplier<AwsCredentialsProvider> delegateConstructor) {
        this.delegateConstructor = delegateConstructor;
    }

    public static LazyAwsCredentialsProvider create(Supplier<AwsCredentialsProvider> delegateConstructor) {
        return new LazyAwsCredentialsProvider(delegateConstructor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AwsCredentials resolveCredentials() {
        if (this.delegate == null) {
            LazyAwsCredentialsProvider lazyAwsCredentialsProvider = this;
            synchronized (lazyAwsCredentialsProvider) {
                if (this.delegate == null) {
                    this.delegate = this.delegateConstructor.get();
                }
            }
        }
        return this.delegate.resolveCredentials();
    }

    public void close() {
        IoUtils.closeIfCloseable((Object)this.delegate, null);
    }

    public String toString() {
        return ToString.builder((String)"LazyAwsCredentialsProvider").add("delegateConstructor", this.delegateConstructor).add("delegate", (Object)this.delegate).build();
    }
}

