/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHookSpecification;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHookSpecificationsCopier;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.services.autoscaling.model.MixedInstancesPolicy;
import software.amazon.awssdk.services.autoscaling.model.Tag;
import software.amazon.awssdk.services.autoscaling.model.TagsCopier;
import software.amazon.awssdk.services.autoscaling.model.TargetGroupARNsCopier;
import software.amazon.awssdk.services.autoscaling.model.TerminationPoliciesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAutoScalingGroupRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, CreateAutoScalingGroupRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::autoScalingGroupName)).setter(CreateAutoScalingGroupRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchConfigurationName").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::launchConfigurationName)).setter(CreateAutoScalingGroupRequest.setter(Builder::launchConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplate").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::launchTemplate)).setter(CreateAutoScalingGroupRequest.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()}).build();
    private static final SdkField<MixedInstancesPolicy> MIXED_INSTANCES_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MixedInstancesPolicy").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::mixedInstancesPolicy)).setter(CreateAutoScalingGroupRequest.setter(Builder::mixedInstancesPolicy)).constructor(MixedInstancesPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedInstancesPolicy").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::instanceId)).setter(CreateAutoScalingGroupRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinSize").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::minSize)).setter(CreateAutoScalingGroupRequest.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSize").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::maxSize)).setter(CreateAutoScalingGroupRequest.setter(Builder::maxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()}).build();
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredCapacity").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::desiredCapacity)).setter(CreateAutoScalingGroupRequest.setter(Builder::desiredCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()}).build();
    private static final SdkField<Integer> DEFAULT_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultCooldown").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::defaultCooldown)).setter(CreateAutoScalingGroupRequest.setter(Builder::defaultCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCooldown").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::availabilityZones)).setter(CreateAutoScalingGroupRequest.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerNames").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::loadBalancerNames)).setter(CreateAutoScalingGroupRequest.setter(Builder::loadBalancerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_GROUP_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetGroupARNs").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::targetGroupARNs)).setter(CreateAutoScalingGroupRequest.setter(Builder::targetGroupARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckType").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::healthCheckType)).setter(CreateAutoScalingGroupRequest.setter(Builder::healthCheckType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthCheckGracePeriod").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::healthCheckGracePeriod)).setter(CreateAutoScalingGroupRequest.setter(Builder::healthCheckGracePeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build()}).build();
    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementGroup").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::placementGroup)).setter(CreateAutoScalingGroupRequest.setter(Builder::placementGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroup").build()}).build();
    private static final SdkField<String> VPC_ZONE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCZoneIdentifier").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::vpcZoneIdentifier)).setter(CreateAutoScalingGroupRequest.setter(Builder::vpcZoneIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCZoneIdentifier").build()}).build();
    private static final SdkField<List<String>> TERMINATION_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TerminationPolicies").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::terminationPolicies)).setter(CreateAutoScalingGroupRequest.setter(Builder::terminationPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NewInstancesProtectedFromScaleIn").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::newInstancesProtectedFromScaleIn)).setter(CreateAutoScalingGroupRequest.setter(Builder::newInstancesProtectedFromScaleIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewInstancesProtectedFromScaleIn").build()}).build();
    private static final SdkField<Boolean> CAPACITY_REBALANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CapacityRebalance").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::capacityRebalance)).setter(CreateAutoScalingGroupRequest.setter(Builder::capacityRebalance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRebalance").build()}).build();
    private static final SdkField<List<LifecycleHookSpecification>> LIFECYCLE_HOOK_SPECIFICATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LifecycleHookSpecificationList").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::lifecycleHookSpecificationList)).setter(CreateAutoScalingGroupRequest.setter(Builder::lifecycleHookSpecificationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookSpecificationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecycleHookSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::tags)).setter(CreateAutoScalingGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_LINKED_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceLinkedRoleARN").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::serviceLinkedRoleARN)).setter(CreateAutoScalingGroupRequest.setter(Builder::serviceLinkedRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkedRoleARN").build()}).build();
    private static final SdkField<Integer> MAX_INSTANCE_LIFETIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxInstanceLifetime").getter(CreateAutoScalingGroupRequest.getter(CreateAutoScalingGroupRequest::maxInstanceLifetime)).setter(CreateAutoScalingGroupRequest.setter(Builder::maxInstanceLifetime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInstanceLifetime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_TEMPLATE_FIELD, MIXED_INSTANCES_POLICY_FIELD, INSTANCE_ID_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, DESIRED_CAPACITY_FIELD, DEFAULT_COOLDOWN_FIELD, AVAILABILITY_ZONES_FIELD, LOAD_BALANCER_NAMES_FIELD, TARGET_GROUP_AR_NS_FIELD, HEALTH_CHECK_TYPE_FIELD, HEALTH_CHECK_GRACE_PERIOD_FIELD, PLACEMENT_GROUP_FIELD, VPC_ZONE_IDENTIFIER_FIELD, TERMINATION_POLICIES_FIELD, NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD, CAPACITY_REBALANCE_FIELD, LIFECYCLE_HOOK_SPECIFICATION_LIST_FIELD, TAGS_FIELD, SERVICE_LINKED_ROLE_ARN_FIELD, MAX_INSTANCE_LIFETIME_FIELD));
    private final String autoScalingGroupName;
    private final String launchConfigurationName;
    private final LaunchTemplateSpecification launchTemplate;
    private final MixedInstancesPolicy mixedInstancesPolicy;
    private final String instanceId;
    private final Integer minSize;
    private final Integer maxSize;
    private final Integer desiredCapacity;
    private final Integer defaultCooldown;
    private final List<String> availabilityZones;
    private final List<String> loadBalancerNames;
    private final List<String> targetGroupARNs;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final String placementGroup;
    private final String vpcZoneIdentifier;
    private final List<String> terminationPolicies;
    private final Boolean newInstancesProtectedFromScaleIn;
    private final Boolean capacityRebalance;
    private final List<LifecycleHookSpecification> lifecycleHookSpecificationList;
    private final List<Tag> tags;
    private final String serviceLinkedRoleARN;
    private final Integer maxInstanceLifetime;

    private CreateAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchTemplate = builder.launchTemplate;
        this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
        this.instanceId = builder.instanceId;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.targetGroupARNs = builder.targetGroupARNs;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.capacityRebalance = builder.capacityRebalance;
        this.lifecycleHookSpecificationList = builder.lifecycleHookSpecificationList;
        this.tags = builder.tags;
        this.serviceLinkedRoleARN = builder.serviceLinkedRoleARN;
        this.maxInstanceLifetime = builder.maxInstanceLifetime;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public MixedInstancesPolicy mixedInstancesPolicy() {
        return this.mixedInstancesPolicy;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Integer minSize() {
        return this.minSize;
    }

    public Integer maxSize() {
        return this.maxSize;
    }

    public Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public Integer defaultCooldown() {
        return this.defaultCooldown;
    }

    public boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public boolean hasLoadBalancerNames() {
        return this.loadBalancerNames != null && !(this.loadBalancerNames instanceof SdkAutoConstructList);
    }

    public List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public boolean hasTargetGroupARNs() {
        return this.targetGroupARNs != null && !(this.targetGroupARNs instanceof SdkAutoConstructList);
    }

    public List<String> targetGroupARNs() {
        return this.targetGroupARNs;
    }

    public String healthCheckType() {
        return this.healthCheckType;
    }

    public Integer healthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public String placementGroup() {
        return this.placementGroup;
    }

    public String vpcZoneIdentifier() {
        return this.vpcZoneIdentifier;
    }

    public boolean hasTerminationPolicies() {
        return this.terminationPolicies != null && !(this.terminationPolicies instanceof SdkAutoConstructList);
    }

    public List<String> terminationPolicies() {
        return this.terminationPolicies;
    }

    public Boolean newInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public Boolean capacityRebalance() {
        return this.capacityRebalance;
    }

    public boolean hasLifecycleHookSpecificationList() {
        return this.lifecycleHookSpecificationList != null && !(this.lifecycleHookSpecificationList instanceof SdkAutoConstructList);
    }

    public List<LifecycleHookSpecification> lifecycleHookSpecificationList() {
        return this.lifecycleHookSpecificationList;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String serviceLinkedRoleARN() {
        return this.serviceLinkedRoleARN;
    }

    public Integer maxInstanceLifetime() {
        return this.maxInstanceLifetime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.mixedInstancesPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerNames() ? this.loadBalancerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroupARNs() ? this.targetGroupARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerminationPolicies() ? this.terminationPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.newInstancesProtectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityRebalance());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecycleHookSpecificationList() ? this.lifecycleHookSpecificationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLinkedRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInstanceLifetime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoScalingGroupRequest)) {
            return false;
        }
        CreateAutoScalingGroupRequest other = (CreateAutoScalingGroupRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.mixedInstancesPolicy(), other.mixedInstancesPolicy()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.defaultCooldown(), other.defaultCooldown()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasLoadBalancerNames() == other.hasLoadBalancerNames() && Objects.equals(this.loadBalancerNames(), other.loadBalancerNames()) && this.hasTargetGroupARNs() == other.hasTargetGroupARNs() && Objects.equals(this.targetGroupARNs(), other.targetGroupARNs()) && Objects.equals(this.healthCheckType(), other.healthCheckType()) && Objects.equals(this.healthCheckGracePeriod(), other.healthCheckGracePeriod()) && Objects.equals(this.placementGroup(), other.placementGroup()) && Objects.equals(this.vpcZoneIdentifier(), other.vpcZoneIdentifier()) && this.hasTerminationPolicies() == other.hasTerminationPolicies() && Objects.equals(this.terminationPolicies(), other.terminationPolicies()) && Objects.equals(this.newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn()) && Objects.equals(this.capacityRebalance(), other.capacityRebalance()) && this.hasLifecycleHookSpecificationList() == other.hasLifecycleHookSpecificationList() && Objects.equals(this.lifecycleHookSpecificationList(), other.lifecycleHookSpecificationList()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.serviceLinkedRoleARN(), other.serviceLinkedRoleARN()) && Objects.equals(this.maxInstanceLifetime(), other.maxInstanceLifetime());
    }

    public String toString() {
        return ToString.builder((String)"CreateAutoScalingGroupRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("LaunchTemplate", (Object)this.launchTemplate()).add("MixedInstancesPolicy", (Object)this.mixedInstancesPolicy()).add("InstanceId", (Object)this.instanceId()).add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("DesiredCapacity", (Object)this.desiredCapacity()).add("DefaultCooldown", (Object)this.defaultCooldown()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("LoadBalancerNames", this.hasLoadBalancerNames() ? this.loadBalancerNames() : null).add("TargetGroupARNs", this.hasTargetGroupARNs() ? this.targetGroupARNs() : null).add("HealthCheckType", (Object)this.healthCheckType()).add("HealthCheckGracePeriod", (Object)this.healthCheckGracePeriod()).add("PlacementGroup", (Object)this.placementGroup()).add("VPCZoneIdentifier", (Object)this.vpcZoneIdentifier()).add("TerminationPolicies", this.hasTerminationPolicies() ? this.terminationPolicies() : null).add("NewInstancesProtectedFromScaleIn", (Object)this.newInstancesProtectedFromScaleIn()).add("CapacityRebalance", (Object)this.capacityRebalance()).add("LifecycleHookSpecificationList", this.hasLifecycleHookSpecificationList() ? this.lifecycleHookSpecificationList() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ServiceLinkedRoleARN", (Object)this.serviceLinkedRoleARN()).add("MaxInstanceLifetime", (Object)this.maxInstanceLifetime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "LaunchConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationName()));
            }
            case "LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "MixedInstancesPolicy": {
                return Optional.ofNullable(clazz.cast(this.mixedInstancesPolicy()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "MinSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "MaxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "DesiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacity()));
            }
            case "DefaultCooldown": {
                return Optional.ofNullable(clazz.cast(this.defaultCooldown()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "LoadBalancerNames": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerNames()));
            }
            case "TargetGroupARNs": {
                return Optional.ofNullable(clazz.cast(this.targetGroupARNs()));
            }
            case "HealthCheckType": {
                return Optional.ofNullable(clazz.cast(this.healthCheckType()));
            }
            case "HealthCheckGracePeriod": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriod()));
            }
            case "PlacementGroup": {
                return Optional.ofNullable(clazz.cast(this.placementGroup()));
            }
            case "VPCZoneIdentifier": {
                return Optional.ofNullable(clazz.cast(this.vpcZoneIdentifier()));
            }
            case "TerminationPolicies": {
                return Optional.ofNullable(clazz.cast(this.terminationPolicies()));
            }
            case "NewInstancesProtectedFromScaleIn": {
                return Optional.ofNullable(clazz.cast(this.newInstancesProtectedFromScaleIn()));
            }
            case "CapacityRebalance": {
                return Optional.ofNullable(clazz.cast(this.capacityRebalance()));
            }
            case "LifecycleHookSpecificationList": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHookSpecificationList()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ServiceLinkedRoleARN": {
                return Optional.ofNullable(clazz.cast(this.serviceLinkedRoleARN()));
            }
            case "MaxInstanceLifetime": {
                return Optional.ofNullable(clazz.cast(this.maxInstanceLifetime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoScalingGroupRequest, T> g) {
        return obj -> g.apply((CreateAutoScalingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String launchConfigurationName;
        private LaunchTemplateSpecification launchTemplate;
        private MixedInstancesPolicy mixedInstancesPolicy;
        private String instanceId;
        private Integer minSize;
        private Integer maxSize;
        private Integer desiredCapacity;
        private Integer defaultCooldown;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetGroupARNs = DefaultSdkAutoConstructList.getInstance();
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private String placementGroup;
        private String vpcZoneIdentifier;
        private List<String> terminationPolicies = DefaultSdkAutoConstructList.getInstance();
        private Boolean newInstancesProtectedFromScaleIn;
        private Boolean capacityRebalance;
        private List<LifecycleHookSpecification> lifecycleHookSpecificationList = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String serviceLinkedRoleARN;
        private Integer maxInstanceLifetime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoScalingGroupRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.launchConfigurationName(model.launchConfigurationName);
            this.launchTemplate(model.launchTemplate);
            this.mixedInstancesPolicy(model.mixedInstancesPolicy);
            this.instanceId(model.instanceId);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.desiredCapacity(model.desiredCapacity);
            this.defaultCooldown(model.defaultCooldown);
            this.availabilityZones(model.availabilityZones);
            this.loadBalancerNames(model.loadBalancerNames);
            this.targetGroupARNs(model.targetGroupARNs);
            this.healthCheckType(model.healthCheckType);
            this.healthCheckGracePeriod(model.healthCheckGracePeriod);
            this.placementGroup(model.placementGroup);
            this.vpcZoneIdentifier(model.vpcZoneIdentifier);
            this.terminationPolicies(model.terminationPolicies);
            this.newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            this.capacityRebalance(model.capacityRebalance);
            this.lifecycleHookSpecificationList(model.lifecycleHookSpecificationList);
            this.tags(model.tags);
            this.serviceLinkedRoleARN(model.serviceLinkedRoleARN);
            this.maxInstanceLifetime(model.maxInstanceLifetime);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        public final MixedInstancesPolicy.Builder getMixedInstancesPolicy() {
            return this.mixedInstancesPolicy != null ? this.mixedInstancesPolicy.toBuilder() : null;
        }

        @Override
        public final Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        public final void setMixedInstancesPolicy(MixedInstancesPolicy.BuilderImpl mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy != null ? mixedInstancesPolicy.build() : null;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getDefaultCooldown() {
            return this.defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<String> getLoadBalancerNames() {
            if (this.loadBalancerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        public final Collection<String> getTargetGroupARNs() {
            if (this.targetGroupARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String ... targetGroupARNs) {
            this.targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        public final String getHealthCheckType() {
            return this.healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final String getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final String getVpcZoneIdentifier() {
            return this.vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final void setVpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        public final Collection<String> getTerminationPolicies() {
            if (this.terminationPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.terminationPolicies;
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String ... terminationPolicies) {
            this.terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        public final Boolean getCapacityRebalance() {
            return this.capacityRebalance;
        }

        @Override
        public final Builder capacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        public final void setCapacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
        }

        public final Collection<LifecycleHookSpecification.Builder> getLifecycleHookSpecificationList() {
            if (this.lifecycleHookSpecificationList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifecycleHookSpecificationList != null ? (Collection)this.lifecycleHookSpecificationList.stream().map(LifecycleHookSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lifecycleHookSpecificationList(Collection<LifecycleHookSpecification> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = LifecycleHookSpecificationsCopier.copy(lifecycleHookSpecificationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookSpecificationList(LifecycleHookSpecification ... lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList(Arrays.asList(lifecycleHookSpecificationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookSpecificationList(Consumer<LifecycleHookSpecification.Builder> ... lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList(Stream.of(lifecycleHookSpecificationList).map(c -> (LifecycleHookSpecification)((LifecycleHookSpecification.Builder)LifecycleHookSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLifecycleHookSpecificationList(Collection<LifecycleHookSpecification.BuilderImpl> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = LifecycleHookSpecificationsCopier.copyFromBuilder(lifecycleHookSpecificationList);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getServiceLinkedRoleARN() {
            return this.serviceLinkedRoleARN;
        }

        @Override
        public final Builder serviceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
            return this;
        }

        public final void setServiceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
        }

        public final Integer getMaxInstanceLifetime() {
            return this.maxInstanceLifetime;
        }

        @Override
        public final Builder maxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public final void setMaxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoScalingGroupRequest build() {
            return new CreateAutoScalingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAutoScalingGroupRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder launchConfigurationName(String var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder mixedInstancesPolicy(MixedInstancesPolicy var1);

        default public Builder mixedInstancesPolicy(Consumer<MixedInstancesPolicy.Builder> mixedInstancesPolicy) {
            return this.mixedInstancesPolicy((MixedInstancesPolicy)((MixedInstancesPolicy.Builder)MixedInstancesPolicy.builder().applyMutation(mixedInstancesPolicy)).build());
        }

        public Builder instanceId(String var1);

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder desiredCapacity(Integer var1);

        public Builder defaultCooldown(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder targetGroupARNs(Collection<String> var1);

        public Builder targetGroupARNs(String ... var1);

        public Builder healthCheckType(String var1);

        public Builder healthCheckGracePeriod(Integer var1);

        public Builder placementGroup(String var1);

        public Builder vpcZoneIdentifier(String var1);

        public Builder terminationPolicies(Collection<String> var1);

        public Builder terminationPolicies(String ... var1);

        public Builder newInstancesProtectedFromScaleIn(Boolean var1);

        public Builder capacityRebalance(Boolean var1);

        public Builder lifecycleHookSpecificationList(Collection<LifecycleHookSpecification> var1);

        public Builder lifecycleHookSpecificationList(LifecycleHookSpecification ... var1);

        public Builder lifecycleHookSpecificationList(Consumer<LifecycleHookSpecification.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder serviceLinkedRoleARN(String var1);

        public Builder maxInstanceLifetime(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

