/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.RefreshPreferences;
import software.amazon.awssdk.services.autoscaling.model.RefreshStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartInstanceRefreshRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, StartInstanceRefreshRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(StartInstanceRefreshRequest.getter(StartInstanceRefreshRequest::autoScalingGroupName)).setter(StartInstanceRefreshRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Strategy").getter(StartInstanceRefreshRequest.getter(StartInstanceRefreshRequest::strategyAsString)).setter(StartInstanceRefreshRequest.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()}).build();
    private static final SdkField<RefreshPreferences> PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Preferences").getter(StartInstanceRefreshRequest.getter(StartInstanceRefreshRequest::preferences)).setter(StartInstanceRefreshRequest.setter(Builder::preferences)).constructor(RefreshPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preferences").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, STRATEGY_FIELD, PREFERENCES_FIELD));
    private final String autoScalingGroupName;
    private final String strategy;
    private final RefreshPreferences preferences;

    private StartInstanceRefreshRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.strategy = builder.strategy;
        this.preferences = builder.preferences;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public RefreshStrategy strategy() {
        return RefreshStrategy.fromValue(this.strategy);
    }

    public String strategyAsString() {
        return this.strategy;
    }

    public RefreshPreferences preferences() {
        return this.preferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferences());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInstanceRefreshRequest)) {
            return false;
        }
        StartInstanceRefreshRequest other = (StartInstanceRefreshRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.preferences(), other.preferences());
    }

    public String toString() {
        return ToString.builder((String)"StartInstanceRefreshRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("Strategy", (Object)this.strategyAsString()).add("Preferences", (Object)this.preferences()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "Preferences": {
                return Optional.ofNullable(clazz.cast(this.preferences()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartInstanceRefreshRequest, T> g) {
        return obj -> g.apply((StartInstanceRefreshRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String strategy;
        private RefreshPreferences preferences;

        private BuilderImpl() {
        }

        private BuilderImpl(StartInstanceRefreshRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.strategy(model.strategy);
            this.preferences(model.preferences);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(RefreshStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public final RefreshPreferences.Builder getPreferences() {
            return this.preferences != null ? this.preferences.toBuilder() : null;
        }

        @Override
        public final Builder preferences(RefreshPreferences preferences) {
            this.preferences = preferences;
            return this;
        }

        public final void setPreferences(RefreshPreferences.BuilderImpl preferences) {
            this.preferences = preferences != null ? preferences.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartInstanceRefreshRequest build() {
            return new StartInstanceRefreshRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartInstanceRefreshRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder strategy(String var1);

        public Builder strategy(RefreshStrategy var1);

        public Builder preferences(RefreshPreferences var1);

        default public Builder preferences(Consumer<RefreshPreferences.Builder> preferences) {
            return this.preferences((RefreshPreferences)((RefreshPreferences.Builder)RefreshPreferences.builder().applyMutation(preferences)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

