/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricType {
    ASG_AVERAGE_CPU_UTILIZATION("ASGAverageCPUUtilization"),
    ASG_AVERAGE_NETWORK_IN("ASGAverageNetworkIn"),
    ASG_AVERAGE_NETWORK_OUT("ASGAverageNetworkOut"),
    ALB_REQUEST_COUNT_PER_TARGET("ALBRequestCountPerTarget"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricType> VALUE_MAP;
    private final String value;

    private MetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricType> knownValues() {
        EnumSet<MetricType> knownValues = EnumSet.allOf(MetricType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricType.class, MetricType::toString);
    }
}

