/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshProgressDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RollbackDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RollbackDetails> {
    private static final SdkField<String> ROLLBACK_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RollbackReason").getter(RollbackDetails.getter(RollbackDetails::rollbackReason)).setter(RollbackDetails.setter(Builder::rollbackReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackReason").build()}).build();
    private static final SdkField<Instant> ROLLBACK_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RollbackStartTime").getter(RollbackDetails.getter(RollbackDetails::rollbackStartTime)).setter(RollbackDetails.setter(Builder::rollbackStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackStartTime").build()}).build();
    private static final SdkField<Integer> PERCENTAGE_COMPLETE_ON_ROLLBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentageCompleteOnRollback").getter(RollbackDetails.getter(RollbackDetails::percentageCompleteOnRollback)).setter(RollbackDetails.setter(Builder::percentageCompleteOnRollback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageCompleteOnRollback").build()}).build();
    private static final SdkField<Integer> INSTANCES_TO_UPDATE_ON_ROLLBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesToUpdateOnRollback").getter(RollbackDetails.getter(RollbackDetails::instancesToUpdateOnRollback)).setter(RollbackDetails.setter(Builder::instancesToUpdateOnRollback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToUpdateOnRollback").build()}).build();
    private static final SdkField<InstanceRefreshProgressDetails> PROGRESS_DETAILS_ON_ROLLBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressDetailsOnRollback").getter(RollbackDetails.getter(RollbackDetails::progressDetailsOnRollback)).setter(RollbackDetails.setter(Builder::progressDetailsOnRollback)).constructor(InstanceRefreshProgressDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressDetailsOnRollback").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLBACK_REASON_FIELD, ROLLBACK_START_TIME_FIELD, PERCENTAGE_COMPLETE_ON_ROLLBACK_FIELD, INSTANCES_TO_UPDATE_ON_ROLLBACK_FIELD, PROGRESS_DETAILS_ON_ROLLBACK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RollbackDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String rollbackReason;
    private final Instant rollbackStartTime;
    private final Integer percentageCompleteOnRollback;
    private final Integer instancesToUpdateOnRollback;
    private final InstanceRefreshProgressDetails progressDetailsOnRollback;

    private RollbackDetails(BuilderImpl builder) {
        this.rollbackReason = builder.rollbackReason;
        this.rollbackStartTime = builder.rollbackStartTime;
        this.percentageCompleteOnRollback = builder.percentageCompleteOnRollback;
        this.instancesToUpdateOnRollback = builder.instancesToUpdateOnRollback;
        this.progressDetailsOnRollback = builder.progressDetailsOnRollback;
    }

    public final String rollbackReason() {
        return this.rollbackReason;
    }

    public final Instant rollbackStartTime() {
        return this.rollbackStartTime;
    }

    public final Integer percentageCompleteOnRollback() {
        return this.percentageCompleteOnRollback;
    }

    public final Integer instancesToUpdateOnRollback() {
        return this.instancesToUpdateOnRollback;
    }

    public final InstanceRefreshProgressDetails progressDetailsOnRollback() {
        return this.progressDetailsOnRollback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageCompleteOnRollback());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesToUpdateOnRollback());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressDetailsOnRollback());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackDetails)) {
            return false;
        }
        RollbackDetails other = (RollbackDetails)obj;
        return Objects.equals(this.rollbackReason(), other.rollbackReason()) && Objects.equals(this.rollbackStartTime(), other.rollbackStartTime()) && Objects.equals(this.percentageCompleteOnRollback(), other.percentageCompleteOnRollback()) && Objects.equals(this.instancesToUpdateOnRollback(), other.instancesToUpdateOnRollback()) && Objects.equals(this.progressDetailsOnRollback(), other.progressDetailsOnRollback());
    }

    public final String toString() {
        return ToString.builder((String)"RollbackDetails").add("RollbackReason", (Object)this.rollbackReason()).add("RollbackStartTime", (Object)this.rollbackStartTime()).add("PercentageCompleteOnRollback", (Object)this.percentageCompleteOnRollback()).add("InstancesToUpdateOnRollback", (Object)this.instancesToUpdateOnRollback()).add("ProgressDetailsOnRollback", (Object)this.progressDetailsOnRollback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RollbackReason": {
                return Optional.ofNullable(clazz.cast(this.rollbackReason()));
            }
            case "RollbackStartTime": {
                return Optional.ofNullable(clazz.cast(this.rollbackStartTime()));
            }
            case "PercentageCompleteOnRollback": {
                return Optional.ofNullable(clazz.cast(this.percentageCompleteOnRollback()));
            }
            case "InstancesToUpdateOnRollback": {
                return Optional.ofNullable(clazz.cast(this.instancesToUpdateOnRollback()));
            }
            case "ProgressDetailsOnRollback": {
                return Optional.ofNullable(clazz.cast(this.progressDetailsOnRollback()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RollbackReason", ROLLBACK_REASON_FIELD);
        map.put("RollbackStartTime", ROLLBACK_START_TIME_FIELD);
        map.put("PercentageCompleteOnRollback", PERCENTAGE_COMPLETE_ON_ROLLBACK_FIELD);
        map.put("InstancesToUpdateOnRollback", INSTANCES_TO_UPDATE_ON_ROLLBACK_FIELD);
        map.put("ProgressDetailsOnRollback", PROGRESS_DETAILS_ON_ROLLBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RollbackDetails, T> g) {
        return obj -> g.apply((RollbackDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rollbackReason;
        private Instant rollbackStartTime;
        private Integer percentageCompleteOnRollback;
        private Integer instancesToUpdateOnRollback;
        private InstanceRefreshProgressDetails progressDetailsOnRollback;

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackDetails model) {
            this.rollbackReason(model.rollbackReason);
            this.rollbackStartTime(model.rollbackStartTime);
            this.percentageCompleteOnRollback(model.percentageCompleteOnRollback);
            this.instancesToUpdateOnRollback(model.instancesToUpdateOnRollback);
            this.progressDetailsOnRollback(model.progressDetailsOnRollback);
        }

        public final String getRollbackReason() {
            return this.rollbackReason;
        }

        public final void setRollbackReason(String rollbackReason) {
            this.rollbackReason = rollbackReason;
        }

        @Override
        public final Builder rollbackReason(String rollbackReason) {
            this.rollbackReason = rollbackReason;
            return this;
        }

        public final Instant getRollbackStartTime() {
            return this.rollbackStartTime;
        }

        public final void setRollbackStartTime(Instant rollbackStartTime) {
            this.rollbackStartTime = rollbackStartTime;
        }

        @Override
        public final Builder rollbackStartTime(Instant rollbackStartTime) {
            this.rollbackStartTime = rollbackStartTime;
            return this;
        }

        public final Integer getPercentageCompleteOnRollback() {
            return this.percentageCompleteOnRollback;
        }

        public final void setPercentageCompleteOnRollback(Integer percentageCompleteOnRollback) {
            this.percentageCompleteOnRollback = percentageCompleteOnRollback;
        }

        @Override
        public final Builder percentageCompleteOnRollback(Integer percentageCompleteOnRollback) {
            this.percentageCompleteOnRollback = percentageCompleteOnRollback;
            return this;
        }

        public final Integer getInstancesToUpdateOnRollback() {
            return this.instancesToUpdateOnRollback;
        }

        public final void setInstancesToUpdateOnRollback(Integer instancesToUpdateOnRollback) {
            this.instancesToUpdateOnRollback = instancesToUpdateOnRollback;
        }

        @Override
        public final Builder instancesToUpdateOnRollback(Integer instancesToUpdateOnRollback) {
            this.instancesToUpdateOnRollback = instancesToUpdateOnRollback;
            return this;
        }

        public final InstanceRefreshProgressDetails.Builder getProgressDetailsOnRollback() {
            return this.progressDetailsOnRollback != null ? this.progressDetailsOnRollback.toBuilder() : null;
        }

        public final void setProgressDetailsOnRollback(InstanceRefreshProgressDetails.BuilderImpl progressDetailsOnRollback) {
            this.progressDetailsOnRollback = progressDetailsOnRollback != null ? progressDetailsOnRollback.build() : null;
        }

        @Override
        public final Builder progressDetailsOnRollback(InstanceRefreshProgressDetails progressDetailsOnRollback) {
            this.progressDetailsOnRollback = progressDetailsOnRollback;
            return this;
        }

        public RollbackDetails build() {
            return new RollbackDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RollbackDetails> {
        public Builder rollbackReason(String var1);

        public Builder rollbackStartTime(Instant var1);

        public Builder percentageCompleteOnRollback(Integer var1);

        public Builder instancesToUpdateOnRollback(Integer var1);

        public Builder progressDetailsOnRollback(InstanceRefreshProgressDetails var1);

        default public Builder progressDetailsOnRollback(Consumer<InstanceRefreshProgressDetails.Builder> progressDetailsOnRollback) {
            return this.progressDetailsOnRollback((InstanceRefreshProgressDetails)((InstanceRefreshProgressDetails.Builder)InstanceRefreshProgressDetails.builder().applyMutation(progressDetailsOnRollback)).build());
        }
    }
}

