/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupPlan;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBackupPlanResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, GetBackupPlanResponse> {
    private static final SdkField<BackupPlan> BACKUP_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetBackupPlanResponse.getter(GetBackupPlanResponse::backupPlan)).setter(GetBackupPlanResponse.setter(Builder::backupPlan)).constructor(BackupPlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlan").build()}).build();
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBackupPlanResponse.getter(GetBackupPlanResponse::backupPlanId)).setter(GetBackupPlanResponse.setter(Builder::backupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()}).build();
    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBackupPlanResponse.getter(GetBackupPlanResponse::backupPlanArn)).setter(GetBackupPlanResponse.setter(Builder::backupPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBackupPlanResponse.getter(GetBackupPlanResponse::versionId)).setter(GetBackupPlanResponse.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBackupPlanResponse.getter(GetBackupPlanResponse::creatorRequestId)).setter(GetBackupPlanResponse.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetBackupPlanResponse.getter(GetBackupPlanResponse::creationDate)).setter(GetBackupPlanResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> DELETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetBackupPlanResponse.getter(GetBackupPlanResponse::deletionDate)).setter(GetBackupPlanResponse.setter(Builder::deletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionDate").build()}).build();
    private static final SdkField<Instant> LAST_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetBackupPlanResponse.getter(GetBackupPlanResponse::lastExecutionDate)).setter(GetBackupPlanResponse.setter(Builder::lastExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_FIELD, BACKUP_PLAN_ID_FIELD, BACKUP_PLAN_ARN_FIELD, VERSION_ID_FIELD, CREATOR_REQUEST_ID_FIELD, CREATION_DATE_FIELD, DELETION_DATE_FIELD, LAST_EXECUTION_DATE_FIELD));
    private final BackupPlan backupPlan;
    private final String backupPlanId;
    private final String backupPlanArn;
    private final String versionId;
    private final String creatorRequestId;
    private final Instant creationDate;
    private final Instant deletionDate;
    private final Instant lastExecutionDate;

    private GetBackupPlanResponse(BuilderImpl builder) {
        super(builder);
        this.backupPlan = builder.backupPlan;
        this.backupPlanId = builder.backupPlanId;
        this.backupPlanArn = builder.backupPlanArn;
        this.versionId = builder.versionId;
        this.creatorRequestId = builder.creatorRequestId;
        this.creationDate = builder.creationDate;
        this.deletionDate = builder.deletionDate;
        this.lastExecutionDate = builder.lastExecutionDate;
    }

    public BackupPlan backupPlan() {
        return this.backupPlan;
    }

    public String backupPlanId() {
        return this.backupPlanId;
    }

    public String backupPlanArn() {
        return this.backupPlanArn;
    }

    public String versionId() {
        return this.versionId;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant deletionDate() {
        return this.deletionDate;
    }

    public Instant lastExecutionDate() {
        return this.lastExecutionDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutionDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackupPlanResponse)) {
            return false;
        }
        GetBackupPlanResponse other = (GetBackupPlanResponse)((Object)obj);
        return Objects.equals(this.backupPlan(), other.backupPlan()) && Objects.equals(this.backupPlanId(), other.backupPlanId()) && Objects.equals(this.backupPlanArn(), other.backupPlanArn()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.deletionDate(), other.deletionDate()) && Objects.equals(this.lastExecutionDate(), other.lastExecutionDate());
    }

    public String toString() {
        return ToString.builder((String)"GetBackupPlanResponse").add("BackupPlan", (Object)this.backupPlan()).add("BackupPlanId", (Object)this.backupPlanId()).add("BackupPlanArn", (Object)this.backupPlanArn()).add("VersionId", (Object)this.versionId()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("CreationDate", (Object)this.creationDate()).add("DeletionDate", (Object)this.deletionDate()).add("LastExecutionDate", (Object)this.lastExecutionDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlan": {
                return Optional.ofNullable(clazz.cast(this.backupPlan()));
            }
            case "BackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.backupPlanId()));
            }
            case "BackupPlanArn": {
                return Optional.ofNullable(clazz.cast(this.backupPlanArn()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "DeletionDate": {
                return Optional.ofNullable(clazz.cast(this.deletionDate()));
            }
            case "LastExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastExecutionDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBackupPlanResponse, T> g) {
        return obj -> g.apply((GetBackupPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private BackupPlan backupPlan;
        private String backupPlanId;
        private String backupPlanArn;
        private String versionId;
        private String creatorRequestId;
        private Instant creationDate;
        private Instant deletionDate;
        private Instant lastExecutionDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackupPlanResponse model) {
            super(model);
            this.backupPlan(model.backupPlan);
            this.backupPlanId(model.backupPlanId);
            this.backupPlanArn(model.backupPlanArn);
            this.versionId(model.versionId);
            this.creatorRequestId(model.creatorRequestId);
            this.creationDate(model.creationDate);
            this.deletionDate(model.deletionDate);
            this.lastExecutionDate(model.lastExecutionDate);
        }

        public final BackupPlan.Builder getBackupPlan() {
            return this.backupPlan != null ? this.backupPlan.toBuilder() : null;
        }

        @Override
        public final Builder backupPlan(BackupPlan backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        public final void setBackupPlan(BackupPlan.BuilderImpl backupPlan) {
            this.backupPlan = backupPlan != null ? backupPlan.build() : null;
        }

        public final String getBackupPlanId() {
            return this.backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        public final String getBackupPlanArn() {
            return this.backupPlanArn;
        }

        @Override
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getDeletionDate() {
            return this.deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        public final Instant getLastExecutionDate() {
            return this.lastExecutionDate;
        }

        @Override
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        @Override
        public GetBackupPlanResponse build() {
            return new GetBackupPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBackupPlanResponse> {
        public Builder backupPlan(BackupPlan var1);

        default public Builder backupPlan(Consumer<BackupPlan.Builder> backupPlan) {
            return this.backupPlan((BackupPlan)((BackupPlan.Builder)BackupPlan.builder().applyMutation(backupPlan)).build());
        }

        public Builder backupPlanId(String var1);

        public Builder backupPlanArn(String var1);

        public Builder versionId(String var1);

        public Builder creatorRequestId(String var1);

        public Builder creationDate(Instant var1);

        public Builder deletionDate(Instant var1);

        public Builder lastExecutionDate(Instant var1);
    }
}

