/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupsearch.model.BackupSearchResponse;
import software.amazon.awssdk.services.backupsearch.model.ExportJobSummariesCopier;
import software.amazon.awssdk.services.backupsearch.model.ExportJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSearchResultExportJobsResponse
extends BackupSearchResponse
implements ToCopyableBuilder<Builder, ListSearchResultExportJobsResponse> {
    private static final SdkField<List<ExportJobSummary>> EXPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportJobs").getter(ListSearchResultExportJobsResponse.getter(ListSearchResultExportJobsResponse::exportJobs)).setter(ListSearchResultExportJobsResponse.setter(Builder::exportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSearchResultExportJobsResponse.getter(ListSearchResultExportJobsResponse::nextToken)).setter(ListSearchResultExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSearchResultExportJobsResponse.memberNameToFieldInitializer();
    private final List<ExportJobSummary> exportJobs;
    private final String nextToken;

    private ListSearchResultExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.exportJobs = builder.exportJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExportJobs() {
        return this.exportJobs != null && !(this.exportJobs instanceof SdkAutoConstructList);
    }

    public final List<ExportJobSummary> exportJobs() {
        return this.exportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportJobs() ? this.exportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSearchResultExportJobsResponse)) {
            return false;
        }
        ListSearchResultExportJobsResponse other = (ListSearchResultExportJobsResponse)((Object)obj);
        return this.hasExportJobs() == other.hasExportJobs() && Objects.equals(this.exportJobs(), other.exportJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSearchResultExportJobsResponse").add("ExportJobs", this.hasExportJobs() ? this.exportJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportJobs": {
                return Optional.ofNullable(clazz.cast(this.exportJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExportJobs", EXPORT_JOBS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSearchResultExportJobsResponse, T> g) {
        return obj -> g.apply((ListSearchResultExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupSearchResponse.BuilderImpl
    implements Builder {
        private List<ExportJobSummary> exportJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSearchResultExportJobsResponse model) {
            super(model);
            this.exportJobs(model.exportJobs);
            this.nextToken(model.nextToken);
        }

        public final List<ExportJobSummary.Builder> getExportJobs() {
            List<ExportJobSummary.Builder> result = ExportJobSummariesCopier.copyToBuilder(this.exportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportJobs(Collection<ExportJobSummary.BuilderImpl> exportJobs) {
            this.exportJobs = ExportJobSummariesCopier.copyFromBuilder(exportJobs);
        }

        @Override
        public final Builder exportJobs(Collection<ExportJobSummary> exportJobs) {
            this.exportJobs = ExportJobSummariesCopier.copy(exportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportJobs(ExportJobSummary ... exportJobs) {
            this.exportJobs(Arrays.asList(exportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportJobs(Consumer<ExportJobSummary.Builder> ... exportJobs) {
            this.exportJobs(Stream.of(exportJobs).map(c -> (ExportJobSummary)((ExportJobSummary.Builder)ExportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSearchResultExportJobsResponse build() {
            return new ListSearchResultExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSearchResultExportJobsResponse> {
        public Builder exportJobs(Collection<ExportJobSummary> var1);

        public Builder exportJobs(ExportJobSummary ... var1);

        public Builder exportJobs(Consumer<ExportJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

