/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkidentity.ChimeSdkIdentityAsyncClient;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsResponse;

public class ListAppInstanceAdminsPublisher
implements SdkPublisher<ListAppInstanceAdminsResponse> {
    private final ChimeSdkIdentityAsyncClient client;
    private final ListAppInstanceAdminsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppInstanceAdminsPublisher(ChimeSdkIdentityAsyncClient client, ListAppInstanceAdminsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppInstanceAdminsPublisher(ChimeSdkIdentityAsyncClient client, ListAppInstanceAdminsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppInstanceAdminsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppInstanceAdminsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppInstanceAdminsResponseFetcher
    implements AsyncPageFetcher<ListAppInstanceAdminsResponse> {
        private ListAppInstanceAdminsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppInstanceAdminsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppInstanceAdminsResponse> nextPage(ListAppInstanceAdminsResponse previousPage) {
            if (previousPage == null) {
                return ListAppInstanceAdminsPublisher.this.client.listAppInstanceAdmins(ListAppInstanceAdminsPublisher.this.firstRequest);
            }
            return ListAppInstanceAdminsPublisher.this.client.listAppInstanceAdmins((ListAppInstanceAdminsRequest)((Object)ListAppInstanceAdminsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

