/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineListCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMediaPipelinesResponse
extends ChimeSdkMediaPipelinesResponse
implements ToCopyableBuilder<Builder, ListMediaPipelinesResponse> {
    private static final SdkField<List<MediaPipelineSummary>> MEDIA_PIPELINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaPipelines").getter(ListMediaPipelinesResponse.getter(ListMediaPipelinesResponse::mediaPipelines)).setter(ListMediaPipelinesResponse.setter(Builder::mediaPipelines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaPipelineSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMediaPipelinesResponse.getter(ListMediaPipelinesResponse::nextToken)).setter(ListMediaPipelinesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PIPELINES_FIELD, NEXT_TOKEN_FIELD));
    private final List<MediaPipelineSummary> mediaPipelines;
    private final String nextToken;

    private ListMediaPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.mediaPipelines = builder.mediaPipelines;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMediaPipelines() {
        return this.mediaPipelines != null && !(this.mediaPipelines instanceof SdkAutoConstructList);
    }

    public final List<MediaPipelineSummary> mediaPipelines() {
        return this.mediaPipelines;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaPipelines() ? this.mediaPipelines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMediaPipelinesResponse)) {
            return false;
        }
        ListMediaPipelinesResponse other = (ListMediaPipelinesResponse)((Object)obj);
        return this.hasMediaPipelines() == other.hasMediaPipelines() && Objects.equals(this.mediaPipelines(), other.mediaPipelines()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMediaPipelinesResponse").add("MediaPipelines", this.hasMediaPipelines() ? this.mediaPipelines() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaPipelines": {
                return Optional.ofNullable(clazz.cast(this.mediaPipelines()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMediaPipelinesResponse, T> g) {
        return obj -> g.apply((ListMediaPipelinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesResponse.BuilderImpl
    implements Builder {
        private List<MediaPipelineSummary> mediaPipelines = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMediaPipelinesResponse model) {
            super(model);
            this.mediaPipelines(model.mediaPipelines);
            this.nextToken(model.nextToken);
        }

        public final List<MediaPipelineSummary.Builder> getMediaPipelines() {
            List<MediaPipelineSummary.Builder> result = MediaPipelineListCopier.copyToBuilder(this.mediaPipelines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaPipelines(Collection<MediaPipelineSummary.BuilderImpl> mediaPipelines) {
            this.mediaPipelines = MediaPipelineListCopier.copyFromBuilder(mediaPipelines);
        }

        @Override
        public final Builder mediaPipelines(Collection<MediaPipelineSummary> mediaPipelines) {
            this.mediaPipelines = MediaPipelineListCopier.copy(mediaPipelines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaPipelines(MediaPipelineSummary ... mediaPipelines) {
            this.mediaPipelines(Arrays.asList(mediaPipelines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaPipelines(Consumer<MediaPipelineSummary.Builder> ... mediaPipelines) {
            this.mediaPipelines(Stream.of(mediaPipelines).map(c -> (MediaPipelineSummary)((MediaPipelineSummary.Builder)MediaPipelineSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMediaPipelinesResponse build() {
            return new ListMediaPipelinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMediaPipelinesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMediaPipelinesResponse> {
        public Builder mediaPipelines(Collection<MediaPipelineSummary> var1);

        public Builder mediaPipelines(MediaPipelineSummary ... var1);

        public Builder mediaPipelines(Consumer<MediaPipelineSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

