/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LayoutOption;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompositedVideoArtifactsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompositedVideoArtifactsConfiguration> {
    private static final SdkField<String> LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Layout").getter(CompositedVideoArtifactsConfiguration.getter(CompositedVideoArtifactsConfiguration::layoutAsString)).setter(CompositedVideoArtifactsConfiguration.setter(Builder::layout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()}).build();
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Resolution").getter(CompositedVideoArtifactsConfiguration.getter(CompositedVideoArtifactsConfiguration::resolutionAsString)).setter(CompositedVideoArtifactsConfiguration.setter(Builder::resolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resolution").build()}).build();
    private static final SdkField<GridViewConfiguration> GRID_VIEW_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GridViewConfiguration").getter(CompositedVideoArtifactsConfiguration.getter(CompositedVideoArtifactsConfiguration::gridViewConfiguration)).setter(CompositedVideoArtifactsConfiguration.setter(Builder::gridViewConfiguration)).constructor(GridViewConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GridViewConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYOUT_FIELD, RESOLUTION_FIELD, GRID_VIEW_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String layout;
    private final String resolution;
    private final GridViewConfiguration gridViewConfiguration;

    private CompositedVideoArtifactsConfiguration(BuilderImpl builder) {
        this.layout = builder.layout;
        this.resolution = builder.resolution;
        this.gridViewConfiguration = builder.gridViewConfiguration;
    }

    public final LayoutOption layout() {
        return LayoutOption.fromValue(this.layout);
    }

    public final String layoutAsString() {
        return this.layout;
    }

    public final ResolutionOption resolution() {
        return ResolutionOption.fromValue(this.resolution);
    }

    public final String resolutionAsString() {
        return this.resolution;
    }

    public final GridViewConfiguration gridViewConfiguration() {
        return this.gridViewConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gridViewConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositedVideoArtifactsConfiguration)) {
            return false;
        }
        CompositedVideoArtifactsConfiguration other = (CompositedVideoArtifactsConfiguration)obj;
        return Objects.equals(this.layoutAsString(), other.layoutAsString()) && Objects.equals(this.resolutionAsString(), other.resolutionAsString()) && Objects.equals(this.gridViewConfiguration(), other.gridViewConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CompositedVideoArtifactsConfiguration").add("Layout", (Object)this.layoutAsString()).add("Resolution", (Object)this.resolutionAsString()).add("GridViewConfiguration", (Object)this.gridViewConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Layout": {
                return Optional.ofNullable(clazz.cast(this.layoutAsString()));
            }
            case "Resolution": {
                return Optional.ofNullable(clazz.cast(this.resolutionAsString()));
            }
            case "GridViewConfiguration": {
                return Optional.ofNullable(clazz.cast(this.gridViewConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompositedVideoArtifactsConfiguration, T> g) {
        return obj -> g.apply((CompositedVideoArtifactsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String layout;
        private String resolution;
        private GridViewConfiguration gridViewConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CompositedVideoArtifactsConfiguration model) {
            this.layout(model.layout);
            this.resolution(model.resolution);
            this.gridViewConfiguration(model.gridViewConfiguration);
        }

        public final String getLayout() {
            return this.layout;
        }

        public final void setLayout(String layout) {
            this.layout = layout;
        }

        @Override
        public final Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Override
        public final Builder layout(LayoutOption layout) {
            this.layout(layout == null ? null : layout.toString());
            return this;
        }

        public final String getResolution() {
            return this.resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public final Builder resolution(ResolutionOption resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        public final GridViewConfiguration.Builder getGridViewConfiguration() {
            return this.gridViewConfiguration != null ? this.gridViewConfiguration.toBuilder() : null;
        }

        public final void setGridViewConfiguration(GridViewConfiguration.BuilderImpl gridViewConfiguration) {
            this.gridViewConfiguration = gridViewConfiguration != null ? gridViewConfiguration.build() : null;
        }

        @Override
        public final Builder gridViewConfiguration(GridViewConfiguration gridViewConfiguration) {
            this.gridViewConfiguration = gridViewConfiguration;
            return this;
        }

        public CompositedVideoArtifactsConfiguration build() {
            return new CompositedVideoArtifactsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompositedVideoArtifactsConfiguration> {
        public Builder layout(String var1);

        public Builder layout(LayoutOption var1);

        public Builder resolution(String var1);

        public Builder resolution(ResolutionOption var1);

        public Builder gridViewConfiguration(GridViewConfiguration var1);

        default public Builder gridViewConfiguration(Consumer<GridViewConfiguration.Builder> gridViewConfiguration) {
            return this.gridViewConfiguration((GridViewConfiguration)((GridViewConfiguration.Builder)GridViewConfiguration.builder().applyMutation(gridViewConfiguration)).build());
        }
    }
}

