/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The StackResource data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StackResource implements SdkPojo, Serializable, ToCopyableBuilder<StackResource.Builder, StackResource> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(StackResource::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(StackResource::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalResourceId").getter(getter(StackResource::logicalResourceId))
            .setter(setter(Builder::logicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()).build();

    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhysicalResourceId").getter(getter(StackResource::physicalResourceId))
            .setter(setter(Builder::physicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(StackResource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(StackResource::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceStatus").getter(getter(StackResource::resourceStatusAsString))
            .setter(setter(Builder::resourceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()).build();

    private static final SdkField<String> RESOURCE_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceStatusReason").getter(getter(StackResource::resourceStatusReason))
            .setter(setter(Builder::resourceStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatusReason").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StackResource::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<StackResourceDriftInformation> DRIFT_INFORMATION_FIELD = SdkField
            .<StackResourceDriftInformation> builder(MarshallingType.SDK_POJO).memberName("DriftInformation")
            .getter(getter(StackResource::driftInformation)).setter(setter(Builder::driftInformation))
            .constructor(StackResourceDriftInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftInformation").build()).build();

    private static final SdkField<ModuleInfo> MODULE_INFO_FIELD = SdkField.<ModuleInfo> builder(MarshallingType.SDK_POJO)
            .memberName("ModuleInfo").getter(getter(StackResource::moduleInfo)).setter(setter(Builder::moduleInfo))
            .constructor(ModuleInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModuleInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            STACK_ID_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, TIMESTAMP_FIELD,
            RESOURCE_STATUS_FIELD, RESOURCE_STATUS_REASON_FIELD, DESCRIPTION_FIELD, DRIFT_INFORMATION_FIELD, MODULE_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stackName;

    private final String stackId;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private final String resourceType;

    private final Instant timestamp;

    private final String resourceStatus;

    private final String resourceStatusReason;

    private final String description;

    private final StackResourceDriftInformation driftInformation;

    private final ModuleInfo moduleInfo;

    private StackResource(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.stackId = builder.stackId;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.timestamp = builder.timestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.description = builder.description;
        this.driftInformation = builder.driftInformation;
        this.moduleInfo = builder.moduleInfo;
    }

    /**
     * <p>
     * The name associated with the stack.
     * </p>
     * 
     * @return The name associated with the stack.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Unique identifier of the stack.
     * </p>
     * 
     * @return Unique identifier of the stack.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The logical name of the resource specified in the template.
     * </p>
     * 
     * @return The logical name of the resource specified in the template.
     */
    public final String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The name or unique identifier that corresponds to a physical instance ID of a resource supported by
     * CloudFormation.
     * </p>
     * 
     * @return The name or unique identifier that corresponds to a physical instance ID of a resource supported by
     *         CloudFormation.
     */
    public final String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * Type of resource. For more information, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon
     * Web Services Resource Types Reference</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return Type of resource. For more information, go to <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >Amazon Web Services Resource Types Reference</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Time the status was updated.
     * </p>
     * 
     * @return Time the status was updated.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Current status of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Current status of the resource.
     * @see ResourceStatus
     */
    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(resourceStatus);
    }

    /**
     * <p>
     * Current status of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Current status of the resource.
     * @see ResourceStatus
     */
    public final String resourceStatusAsString() {
        return resourceStatus;
    }

    /**
     * <p>
     * Success/failure message associated with the resource.
     * </p>
     * 
     * @return Success/failure message associated with the resource.
     */
    public final String resourceStatusReason() {
        return resourceStatusReason;
    }

    /**
     * <p>
     * User defined description associated with the resource.
     * </p>
     * 
     * @return User defined description associated with the resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected
     * configuration, as defined in the stack template and any values specified as template parameters. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * 
     * @return Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its
     *         expected configuration, as defined in the stack template and any values specified as template parameters.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html"
     *         >Detecting Unregulated Configuration Changes to Stacks and Resources</a>.
     */
    public final StackResourceDriftInformation driftInformation() {
        return driftInformation;
    }

    /**
     * <p>
     * Contains information about the module from which the resource was created, if the resource was created from a
     * module included in the stack template.
     * </p>
     * 
     * @return Contains information about the module from which the resource was created, if the resource was created
     *         from a module included in the stack template.
     */
    public final ModuleInfo moduleInfo() {
        return moduleInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(driftInformation());
        hashCode = 31 * hashCode + Objects.hashCode(moduleInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackResource)) {
            return false;
        }
        StackResource other = (StackResource) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(resourceStatusAsString(), other.resourceStatusAsString())
                && Objects.equals(resourceStatusReason(), other.resourceStatusReason())
                && Objects.equals(description(), other.description())
                && Objects.equals(driftInformation(), other.driftInformation())
                && Objects.equals(moduleInfo(), other.moduleInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StackResource").add("StackName", stackName()).add("StackId", stackId())
                .add("LogicalResourceId", logicalResourceId()).add("PhysicalResourceId", physicalResourceId())
                .add("ResourceType", resourceType()).add("Timestamp", timestamp())
                .add("ResourceStatus", resourceStatusAsString()).add("ResourceStatusReason", resourceStatusReason())
                .add("Description", description()).add("DriftInformation", driftInformation()).add("ModuleInfo", moduleInfo())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "LogicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "PhysicalResourceId":
            return Optional.ofNullable(clazz.cast(physicalResourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "ResourceStatus":
            return Optional.ofNullable(clazz.cast(resourceStatusAsString()));
        case "ResourceStatusReason":
            return Optional.ofNullable(clazz.cast(resourceStatusReason()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DriftInformation":
            return Optional.ofNullable(clazz.cast(driftInformation()));
        case "ModuleInfo":
            return Optional.ofNullable(clazz.cast(moduleInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackResource, T> g) {
        return obj -> g.apply((StackResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StackResource> {
        /**
         * <p>
         * The name associated with the stack.
         * </p>
         * 
         * @param stackName
         *        The name associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Unique identifier of the stack.
         * </p>
         * 
         * @param stackId
         *        Unique identifier of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The logical name of the resource specified in the template.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical name of the resource specified in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The name or unique identifier that corresponds to a physical instance ID of a resource supported by
         * CloudFormation.
         * </p>
         * 
         * @param physicalResourceId
         *        The name or unique identifier that corresponds to a physical instance ID of a resource supported by
         *        CloudFormation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * Type of resource. For more information, go to <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >Amazon Web Services Resource Types Reference</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param resourceType
         *        Type of resource. For more information, go to <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >Amazon Web Services Resource Types Reference</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Time the status was updated.
         * </p>
         * 
         * @param timestamp
         *        Time the status was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(String resourceStatus);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * Success/failure message associated with the resource.
         * </p>
         * 
         * @param resourceStatusReason
         *        Success/failure message associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatusReason(String resourceStatusReason);

        /**
         * <p>
         * User defined description associated with the resource.
         * </p>
         * 
         * @param description
         *        User defined description associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its
         * expected configuration, as defined in the stack template and any values specified as template parameters. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
         * Unregulated Configuration Changes to Stacks and Resources</a>.
         * </p>
         * 
         * @param driftInformation
         *        Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its
         *        expected configuration, as defined in the stack template and any values specified as template
         *        parameters. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html"
         *        >Detecting Unregulated Configuration Changes to Stacks and Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftInformation(StackResourceDriftInformation driftInformation);

        /**
         * <p>
         * Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its
         * expected configuration, as defined in the stack template and any values specified as template parameters. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
         * Unregulated Configuration Changes to Stacks and Resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link StackResourceDriftInformation.Builder}
         * avoiding the need to create one manually via {@link StackResourceDriftInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StackResourceDriftInformation.Builder#build()} is called
         * immediately and its result is passed to {@link #driftInformation(StackResourceDriftInformation)}.
         * 
         * @param driftInformation
         *        a consumer that will call methods on {@link StackResourceDriftInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driftInformation(StackResourceDriftInformation)
         */
        default Builder driftInformation(Consumer<StackResourceDriftInformation.Builder> driftInformation) {
            return driftInformation(StackResourceDriftInformation.builder().applyMutation(driftInformation).build());
        }

        /**
         * <p>
         * Contains information about the module from which the resource was created, if the resource was created from a
         * module included in the stack template.
         * </p>
         * 
         * @param moduleInfo
         *        Contains information about the module from which the resource was created, if the resource was created
         *        from a module included in the stack template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moduleInfo(ModuleInfo moduleInfo);

        /**
         * <p>
         * Contains information about the module from which the resource was created, if the resource was created from a
         * module included in the stack template.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleInfo.Builder} avoiding the need to
         * create one manually via {@link ModuleInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #moduleInfo(ModuleInfo)}.
         * 
         * @param moduleInfo
         *        a consumer that will call methods on {@link ModuleInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moduleInfo(ModuleInfo)
         */
        default Builder moduleInfo(Consumer<ModuleInfo.Builder> moduleInfo) {
            return moduleInfo(ModuleInfo.builder().applyMutation(moduleInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stackName;

        private String stackId;

        private String logicalResourceId;

        private String physicalResourceId;

        private String resourceType;

        private Instant timestamp;

        private String resourceStatus;

        private String resourceStatusReason;

        private String description;

        private StackResourceDriftInformation driftInformation;

        private ModuleInfo moduleInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(StackResource model) {
            stackName(model.stackName);
            stackId(model.stackId);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
            resourceType(model.resourceType);
            timestamp(model.timestamp);
            resourceStatus(model.resourceStatus);
            resourceStatusReason(model.resourceStatusReason);
            description(model.description);
            driftInformation(model.driftInformation);
            moduleInfo(model.moduleInfo);
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getResourceStatus() {
            return resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getResourceStatusReason() {
            return resourceStatusReason;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final StackResourceDriftInformation.Builder getDriftInformation() {
            return driftInformation != null ? driftInformation.toBuilder() : null;
        }

        public final void setDriftInformation(StackResourceDriftInformation.BuilderImpl driftInformation) {
            this.driftInformation = driftInformation != null ? driftInformation.build() : null;
        }

        @Override
        public final Builder driftInformation(StackResourceDriftInformation driftInformation) {
            this.driftInformation = driftInformation;
            return this;
        }

        public final ModuleInfo.Builder getModuleInfo() {
            return moduleInfo != null ? moduleInfo.toBuilder() : null;
        }

        public final void setModuleInfo(ModuleInfo.BuilderImpl moduleInfo) {
            this.moduleInfo = moduleInfo != null ? moduleInfo.build() : null;
        }

        @Override
        public final Builder moduleInfo(ModuleInfo moduleInfo) {
            this.moduleInfo = moduleInfo;
            return this;
        }

        @Override
        public StackResource build() {
            return new StackResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
