/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the progress of the template generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateProgress implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateProgress.Builder, TemplateProgress> {
    private static final SdkField<Integer> RESOURCES_SUCCEEDED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResourcesSucceeded").getter(getter(TemplateProgress::resourcesSucceeded))
            .setter(setter(Builder::resourcesSucceeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesSucceeded").build())
            .build();

    private static final SdkField<Integer> RESOURCES_FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResourcesFailed").getter(getter(TemplateProgress::resourcesFailed))
            .setter(setter(Builder::resourcesFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesFailed").build()).build();

    private static final SdkField<Integer> RESOURCES_PROCESSING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResourcesProcessing").getter(getter(TemplateProgress::resourcesProcessing))
            .setter(setter(Builder::resourcesProcessing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesProcessing").build())
            .build();

    private static final SdkField<Integer> RESOURCES_PENDING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResourcesPending").getter(getter(TemplateProgress::resourcesPending))
            .setter(setter(Builder::resourcesPending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesPending").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_SUCCEEDED_FIELD,
            RESOURCES_FAILED_FIELD, RESOURCES_PROCESSING_FIELD, RESOURCES_PENDING_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer resourcesSucceeded;

    private final Integer resourcesFailed;

    private final Integer resourcesProcessing;

    private final Integer resourcesPending;

    private TemplateProgress(BuilderImpl builder) {
        this.resourcesSucceeded = builder.resourcesSucceeded;
        this.resourcesFailed = builder.resourcesFailed;
        this.resourcesProcessing = builder.resourcesProcessing;
        this.resourcesPending = builder.resourcesPending;
    }

    /**
     * <p>
     * The number of resources that succeeded the template generation.
     * </p>
     * 
     * @return The number of resources that succeeded the template generation.
     */
    public final Integer resourcesSucceeded() {
        return resourcesSucceeded;
    }

    /**
     * <p>
     * The number of resources that failed the template generation.
     * </p>
     * 
     * @return The number of resources that failed the template generation.
     */
    public final Integer resourcesFailed() {
        return resourcesFailed;
    }

    /**
     * <p>
     * The number of resources that are in-process for the template generation.
     * </p>
     * 
     * @return The number of resources that are in-process for the template generation.
     */
    public final Integer resourcesProcessing() {
        return resourcesProcessing;
    }

    /**
     * <p>
     * The number of resources that are still pending the template generation.
     * </p>
     * 
     * @return The number of resources that are still pending the template generation.
     */
    public final Integer resourcesPending() {
        return resourcesPending;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourcesSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesFailed());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesPending());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateProgress)) {
            return false;
        }
        TemplateProgress other = (TemplateProgress) obj;
        return Objects.equals(resourcesSucceeded(), other.resourcesSucceeded())
                && Objects.equals(resourcesFailed(), other.resourcesFailed())
                && Objects.equals(resourcesProcessing(), other.resourcesProcessing())
                && Objects.equals(resourcesPending(), other.resourcesPending());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateProgress").add("ResourcesSucceeded", resourcesSucceeded())
                .add("ResourcesFailed", resourcesFailed()).add("ResourcesProcessing", resourcesProcessing())
                .add("ResourcesPending", resourcesPending()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourcesSucceeded":
            return Optional.ofNullable(clazz.cast(resourcesSucceeded()));
        case "ResourcesFailed":
            return Optional.ofNullable(clazz.cast(resourcesFailed()));
        case "ResourcesProcessing":
            return Optional.ofNullable(clazz.cast(resourcesProcessing()));
        case "ResourcesPending":
            return Optional.ofNullable(clazz.cast(resourcesPending()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateProgress, T> g) {
        return obj -> g.apply((TemplateProgress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateProgress> {
        /**
         * <p>
         * The number of resources that succeeded the template generation.
         * </p>
         * 
         * @param resourcesSucceeded
         *        The number of resources that succeeded the template generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesSucceeded(Integer resourcesSucceeded);

        /**
         * <p>
         * The number of resources that failed the template generation.
         * </p>
         * 
         * @param resourcesFailed
         *        The number of resources that failed the template generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesFailed(Integer resourcesFailed);

        /**
         * <p>
         * The number of resources that are in-process for the template generation.
         * </p>
         * 
         * @param resourcesProcessing
         *        The number of resources that are in-process for the template generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesProcessing(Integer resourcesProcessing);

        /**
         * <p>
         * The number of resources that are still pending the template generation.
         * </p>
         * 
         * @param resourcesPending
         *        The number of resources that are still pending the template generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesPending(Integer resourcesPending);
    }

    static final class BuilderImpl implements Builder {
        private Integer resourcesSucceeded;

        private Integer resourcesFailed;

        private Integer resourcesProcessing;

        private Integer resourcesPending;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateProgress model) {
            resourcesSucceeded(model.resourcesSucceeded);
            resourcesFailed(model.resourcesFailed);
            resourcesProcessing(model.resourcesProcessing);
            resourcesPending(model.resourcesPending);
        }

        public final Integer getResourcesSucceeded() {
            return resourcesSucceeded;
        }

        public final void setResourcesSucceeded(Integer resourcesSucceeded) {
            this.resourcesSucceeded = resourcesSucceeded;
        }

        @Override
        public final Builder resourcesSucceeded(Integer resourcesSucceeded) {
            this.resourcesSucceeded = resourcesSucceeded;
            return this;
        }

        public final Integer getResourcesFailed() {
            return resourcesFailed;
        }

        public final void setResourcesFailed(Integer resourcesFailed) {
            this.resourcesFailed = resourcesFailed;
        }

        @Override
        public final Builder resourcesFailed(Integer resourcesFailed) {
            this.resourcesFailed = resourcesFailed;
            return this;
        }

        public final Integer getResourcesProcessing() {
            return resourcesProcessing;
        }

        public final void setResourcesProcessing(Integer resourcesProcessing) {
            this.resourcesProcessing = resourcesProcessing;
        }

        @Override
        public final Builder resourcesProcessing(Integer resourcesProcessing) {
            this.resourcesProcessing = resourcesProcessing;
            return this;
        }

        public final Integer getResourcesPending() {
            return resourcesPending;
        }

        public final void setResourcesPending(Integer resourcesPending) {
            this.resourcesPending = resourcesPending;
        }

        @Override
        public final Builder resourcesPending(Integer resourcesPending) {
            this.resourcesPending = resourcesPending;
            return this;
        }

        @Override
        public TemplateProgress build() {
            return new TemplateProgress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
