/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.internal.cookie;

import java.net.URI;
import java.util.Objects;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.cloudfront.cookie.CookiesForCustomPolicy;
import software.amazon.awssdk.utils.ToString;

@Immutable
@ThreadSafe
@SdkInternalApi
public final class DefaultCookiesForCustomPolicy
implements CookiesForCustomPolicy {
    private final String resourceUrl;
    private final String signatureHeaderValue;
    private final String keyPairIdHeaderValue;
    private final String policyHeaderValue;

    private DefaultCookiesForCustomPolicy(DefaultBuilder builder) {
        this.resourceUrl = builder.resourceUrl;
        this.signatureHeaderValue = builder.signatureHeaderValue;
        this.keyPairIdHeaderValue = builder.keyPairIdHeaderValue;
        this.policyHeaderValue = builder.policyHeaderValue;
    }

    public static CookiesForCustomPolicy.Builder builder() {
        return new DefaultBuilder();
    }

    public CookiesForCustomPolicy.Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public String toString() {
        return ToString.builder((String)"DefaultCookiesForCustomPolicy").add("resourceUrl", (Object)this.resourceUrl).add("signatureHeaderValue", (Object)this.signatureHeaderValue).add("keyPairIdHeaderValue", (Object)this.keyPairIdHeaderValue).add("policyHeaderValue", (Object)this.policyHeaderValue).build();
    }

    @Override
    public String resourceUrl() {
        return this.resourceUrl;
    }

    @Override
    public SdkHttpRequest createHttpGetRequest() {
        return (SdkHttpRequest)SdkHttpRequest.builder().uri(URI.create(this.resourceUrl)).appendHeader("Cookie", this.policyHeaderValue()).appendHeader("Cookie", this.signatureHeaderValue()).appendHeader("Cookie", this.keyPairIdHeaderValue()).method(SdkHttpMethod.GET).build();
    }

    @Override
    public String signatureHeaderValue() {
        return this.signatureHeaderValue;
    }

    @Override
    public String keyPairIdHeaderValue() {
        return this.keyPairIdHeaderValue;
    }

    @Override
    public String policyHeaderValue() {
        return this.policyHeaderValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCookiesForCustomPolicy cookie = (DefaultCookiesForCustomPolicy)o;
        return Objects.equals(this.keyPairIdHeaderValue, cookie.keyPairIdHeaderValue) && Objects.equals(this.signatureHeaderValue, cookie.signatureHeaderValue) && Objects.equals(this.resourceUrl, cookie.resourceUrl) && Objects.equals(this.policyHeaderValue, cookie.policyHeaderValue);
    }

    public int hashCode() {
        int result = this.keyPairIdHeaderValue != null ? this.keyPairIdHeaderValue.hashCode() : 0;
        result = 31 * result + (this.signatureHeaderValue != null ? this.signatureHeaderValue.hashCode() : 0);
        result = 31 * result + (this.resourceUrl != null ? this.resourceUrl.hashCode() : 0);
        result = 31 * result + (this.policyHeaderValue != null ? this.policyHeaderValue.hashCode() : 0);
        return result;
    }

    private static final class DefaultBuilder
    implements CookiesForCustomPolicy.Builder {
        private String resourceUrl;
        private String signatureHeaderValue;
        private String keyPairIdHeaderValue;
        private String policyHeaderValue;

        private DefaultBuilder() {
        }

        private DefaultBuilder(DefaultCookiesForCustomPolicy cookies) {
            this.resourceUrl = cookies.resourceUrl;
            this.signatureHeaderValue = cookies.signatureHeaderValue;
            this.keyPairIdHeaderValue = cookies.keyPairIdHeaderValue;
            this.policyHeaderValue = cookies.policyHeaderValue;
        }

        @Override
        public CookiesForCustomPolicy.Builder resourceUrl(String resourceUrl) {
            this.resourceUrl = resourceUrl;
            return this;
        }

        @Override
        public CookiesForCustomPolicy.Builder signatureHeaderValue(String signatureHeaderValue) {
            this.signatureHeaderValue = signatureHeaderValue;
            return this;
        }

        @Override
        public CookiesForCustomPolicy.Builder keyPairIdHeaderValue(String keyPairIdHeaderValue) {
            this.keyPairIdHeaderValue = keyPairIdHeaderValue;
            return this;
        }

        @Override
        public CookiesForCustomPolicy.Builder policyHeaderValue(String policyHeaderValue) {
            this.policyHeaderValue = policyHeaderValue;
            return this;
        }

        public DefaultCookiesForCustomPolicy build() {
            return new DefaultCookiesForCustomPolicy(this);
        }
    }
}

