/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCachePoliciesRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListCachePoliciesRequest.Builder, ListCachePoliciesRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(ListCachePoliciesRequest::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListCachePoliciesRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListCachePoliciesRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MARKER_FIELD,
            MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String type;

    private final String marker;

    private final String maxItems;

    private ListCachePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A filter to return only the specified kinds of cache policies. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>managed</code> – Returns only the managed policies created by Amazon Web Services.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CachePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return A filter to return only the specified kinds of cache policies. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>managed</code> – Returns only the managed policies created by Amazon Web Services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.
     *         </p>
     *         </li>
     * @see CachePolicyType
     */
    public final CachePolicyType type() {
        return CachePolicyType.fromValue(type);
    }

    /**
     * <p>
     * A filter to return only the specified kinds of cache policies. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>managed</code> – Returns only the managed policies created by Amazon Web Services.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CachePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return A filter to return only the specified kinds of cache policies. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>managed</code> – Returns only the managed policies created by Amazon Web Services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.
     *         </p>
     *         </li>
     * @see CachePolicyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Use this field when paginating results to indicate where to begin in your list of cache policies. The response
     * includes cache policies in the list that occur after the marker. To get the next page of the list, set this
     * field's value to the value of <code>NextMarker</code> from the current page's response.
     * </p>
     * 
     * @return Use this field when paginating results to indicate where to begin in your list of cache policies. The
     *         response includes cache policies in the list that occur after the marker. To get the next page of the
     *         list, set this field's value to the value of <code>NextMarker</code> from the current page's response.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of cache policies that you want in the response.
     * </p>
     * 
     * @return The maximum number of cache policies that you want in the response.
     */
    public final String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCachePoliciesRequest)) {
            return false;
        }
        ListCachePoliciesRequest other = (ListCachePoliciesRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCachePoliciesRequest").add("Type", typeAsString()).add("Marker", marker())
                .add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCachePoliciesRequest, T> g) {
        return obj -> g.apply((ListCachePoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCachePoliciesRequest> {
        /**
         * <p>
         * A filter to return only the specified kinds of cache policies. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>managed</code> – Returns only the managed policies created by Amazon Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        A filter to return only the specified kinds of cache policies. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>managed</code> – Returns only the managed policies created by Amazon Web Services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.
         *        </p>
         *        </li>
         * @see CachePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CachePolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * A filter to return only the specified kinds of cache policies. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>managed</code> – Returns only the managed policies created by Amazon Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        A filter to return only the specified kinds of cache policies. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>managed</code> – Returns only the managed policies created by Amazon Web Services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.
         *        </p>
         *        </li>
         * @see CachePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CachePolicyType
         */
        Builder type(CachePolicyType type);

        /**
         * <p>
         * Use this field when paginating results to indicate where to begin in your list of cache policies. The
         * response includes cache policies in the list that occur after the marker. To get the next page of the list,
         * set this field's value to the value of <code>NextMarker</code> from the current page's response.
         * </p>
         * 
         * @param marker
         *        Use this field when paginating results to indicate where to begin in your list of cache policies. The
         *        response includes cache policies in the list that occur after the marker. To get the next page of the
         *        list, set this field's value to the value of <code>NextMarker</code> from the current page's response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of cache policies that you want in the response.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of cache policies that you want in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String type;

        private String marker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCachePoliciesRequest model) {
            super(model);
            type(model.type);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CachePolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCachePoliciesRequest build() {
            return new ListCachePoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
