/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKeyGroupsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListKeyGroupsResponse.Builder, ListKeyGroupsResponse> {
    private static final SdkField<KeyGroupList> KEY_GROUP_LIST_FIELD = SdkField
            .<KeyGroupList> builder(MarshallingType.SDK_POJO)
            .memberName("KeyGroupList")
            .getter(getter(ListKeyGroupsResponse::keyGroupList))
            .setter(setter(Builder::keyGroupList))
            .constructor(KeyGroupList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyGroupList")
                    .unmarshallLocationName("KeyGroupList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_GROUP_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final KeyGroupList keyGroupList;

    private ListKeyGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.keyGroupList = builder.keyGroupList;
    }

    /**
     * <p>
     * A list of key groups.
     * </p>
     * 
     * @return A list of key groups.
     */
    public final KeyGroupList keyGroupList() {
        return keyGroupList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyGroupList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyGroupsResponse)) {
            return false;
        }
        ListKeyGroupsResponse other = (ListKeyGroupsResponse) obj;
        return Objects.equals(keyGroupList(), other.keyGroupList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListKeyGroupsResponse").add("KeyGroupList", keyGroupList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyGroupList":
            return Optional.ofNullable(clazz.cast(keyGroupList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyGroupList", KEY_GROUP_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKeyGroupsResponse, T> g) {
        return obj -> g.apply((ListKeyGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListKeyGroupsResponse> {
        /**
         * <p>
         * A list of key groups.
         * </p>
         * 
         * @param keyGroupList
         *        A list of key groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyGroupList(KeyGroupList keyGroupList);

        /**
         * <p>
         * A list of key groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyGroupList.Builder} avoiding the need
         * to create one manually via {@link KeyGroupList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyGroupList.Builder#build()} is called immediately and its
         * result is passed to {@link #keyGroupList(KeyGroupList)}.
         * 
         * @param keyGroupList
         *        a consumer that will call methods on {@link KeyGroupList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyGroupList(KeyGroupList)
         */
        default Builder keyGroupList(Consumer<KeyGroupList.Builder> keyGroupList) {
            return keyGroupList(KeyGroupList.builder().applyMutation(keyGroupList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private KeyGroupList keyGroupList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeyGroupsResponse model) {
            super(model);
            keyGroupList(model.keyGroupList);
        }

        public final KeyGroupList.Builder getKeyGroupList() {
            return keyGroupList != null ? keyGroupList.toBuilder() : null;
        }

        public final void setKeyGroupList(KeyGroupList.BuilderImpl keyGroupList) {
            this.keyGroupList = keyGroupList != null ? keyGroupList.build() : null;
        }

        @Override
        public final Builder keyGroupList(KeyGroupList keyGroupList) {
            this.keyGroupList = keyGroupList;
            return this;
        }

        @Override
        public ListKeyGroupsResponse build() {
            return new ListKeyGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
