/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVpcOriginRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateVpcOriginRequest.Builder, UpdateVpcOriginRequest> {
    private static final SdkField<VpcOriginEndpointConfig> VPC_ORIGIN_ENDPOINT_CONFIG_FIELD = SdkField
            .<VpcOriginEndpointConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcOriginEndpointConfig")
            .getter(getter(UpdateVpcOriginRequest::vpcOriginEndpointConfig))
            .setter(setter(Builder::vpcOriginEndpointConfig))
            .constructor(VpcOriginEndpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOriginEndpointConfig")
                    .unmarshallLocationName("VpcOriginEndpointConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateVpcOriginRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateVpcOriginRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_ORIGIN_ENDPOINT_CONFIG_FIELD, ID_FIELD, IF_MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcOriginEndpointConfig vpcOriginEndpointConfig;

    private final String id;

    private final String ifMatch;

    private UpdateVpcOriginRequest(BuilderImpl builder) {
        super(builder);
        this.vpcOriginEndpointConfig = builder.vpcOriginEndpointConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The VPC origin endpoint configuration.
     * </p>
     * 
     * @return The VPC origin endpoint configuration.
     */
    public final VpcOriginEndpointConfig vpcOriginEndpointConfig() {
        return vpcOriginEndpointConfig;
    }

    /**
     * <p>
     * The VPC origin ID.
     * </p>
     * 
     * @return The VPC origin ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The VPC origin to update, if a match occurs.
     * </p>
     * 
     * @return The VPC origin to update, if a match occurs.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcOriginEndpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcOriginRequest)) {
            return false;
        }
        UpdateVpcOriginRequest other = (UpdateVpcOriginRequest) obj;
        return Objects.equals(vpcOriginEndpointConfig(), other.vpcOriginEndpointConfig()) && Objects.equals(id(), other.id())
                && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVpcOriginRequest").add("VpcOriginEndpointConfig", vpcOriginEndpointConfig())
                .add("Id", id()).add("IfMatch", ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcOriginEndpointConfig":
            return Optional.ofNullable(clazz.cast(vpcOriginEndpointConfig()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcOriginEndpointConfig", VPC_ORIGIN_ENDPOINT_CONFIG_FIELD);
        map.put("Id", ID_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcOriginRequest, T> g) {
        return obj -> g.apply((UpdateVpcOriginRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVpcOriginRequest> {
        /**
         * <p>
         * The VPC origin endpoint configuration.
         * </p>
         * 
         * @param vpcOriginEndpointConfig
         *        The VPC origin endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOriginEndpointConfig(VpcOriginEndpointConfig vpcOriginEndpointConfig);

        /**
         * <p>
         * The VPC origin endpoint configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcOriginEndpointConfig.Builder} avoiding
         * the need to create one manually via {@link VpcOriginEndpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcOriginEndpointConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcOriginEndpointConfig(VpcOriginEndpointConfig)}.
         * 
         * @param vpcOriginEndpointConfig
         *        a consumer that will call methods on {@link VpcOriginEndpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOriginEndpointConfig(VpcOriginEndpointConfig)
         */
        default Builder vpcOriginEndpointConfig(Consumer<VpcOriginEndpointConfig.Builder> vpcOriginEndpointConfig) {
            return vpcOriginEndpointConfig(VpcOriginEndpointConfig.builder().applyMutation(vpcOriginEndpointConfig).build());
        }

        /**
         * <p>
         * The VPC origin ID.
         * </p>
         * 
         * @param id
         *        The VPC origin ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The VPC origin to update, if a match occurs.
         * </p>
         * 
         * @param ifMatch
         *        The VPC origin to update, if a match occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private VpcOriginEndpointConfig vpcOriginEndpointConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcOriginRequest model) {
            super(model);
            vpcOriginEndpointConfig(model.vpcOriginEndpointConfig);
            id(model.id);
            ifMatch(model.ifMatch);
        }

        public final VpcOriginEndpointConfig.Builder getVpcOriginEndpointConfig() {
            return vpcOriginEndpointConfig != null ? vpcOriginEndpointConfig.toBuilder() : null;
        }

        public final void setVpcOriginEndpointConfig(VpcOriginEndpointConfig.BuilderImpl vpcOriginEndpointConfig) {
            this.vpcOriginEndpointConfig = vpcOriginEndpointConfig != null ? vpcOriginEndpointConfig.build() : null;
        }

        @Override
        public final Builder vpcOriginEndpointConfig(VpcOriginEndpointConfig vpcOriginEndpointConfig) {
            this.vpcOriginEndpointConfig = vpcOriginEndpointConfig;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVpcOriginRequest build() {
            return new UpdateVpcOriginRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
