/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOriginRequestPolicyRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateOriginRequestPolicyRequest> {
    private static final SdkField<OriginRequestPolicyConfig> ORIGIN_REQUEST_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginRequestPolicyConfig").getter(CreateOriginRequestPolicyRequest.getter(CreateOriginRequestPolicyRequest::originRequestPolicyConfig)).setter(CreateOriginRequestPolicyRequest.setter(Builder::originRequestPolicyConfig)).constructor(OriginRequestPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicyConfig").unmarshallLocationName("OriginRequestPolicyConfig").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_REQUEST_POLICY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOriginRequestPolicyRequest.memberNameToFieldInitializer();
    private final OriginRequestPolicyConfig originRequestPolicyConfig;

    private CreateOriginRequestPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.originRequestPolicyConfig = builder.originRequestPolicyConfig;
    }

    public final OriginRequestPolicyConfig originRequestPolicyConfig() {
        return this.originRequestPolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originRequestPolicyConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOriginRequestPolicyRequest)) {
            return false;
        }
        CreateOriginRequestPolicyRequest other = (CreateOriginRequestPolicyRequest)((Object)obj);
        return Objects.equals(this.originRequestPolicyConfig(), other.originRequestPolicyConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOriginRequestPolicyRequest").add("OriginRequestPolicyConfig", (Object)this.originRequestPolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginRequestPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.originRequestPolicyConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<OriginRequestPolicyConfig>> map = new HashMap<String, SdkField<OriginRequestPolicyConfig>>();
        map.put("OriginRequestPolicyConfig", ORIGIN_REQUEST_POLICY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOriginRequestPolicyRequest, T> g) {
        return obj -> g.apply((CreateOriginRequestPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private OriginRequestPolicyConfig originRequestPolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOriginRequestPolicyRequest model) {
            super(model);
            this.originRequestPolicyConfig(model.originRequestPolicyConfig);
        }

        public final OriginRequestPolicyConfig.Builder getOriginRequestPolicyConfig() {
            return this.originRequestPolicyConfig != null ? this.originRequestPolicyConfig.toBuilder() : null;
        }

        public final void setOriginRequestPolicyConfig(OriginRequestPolicyConfig.BuilderImpl originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig != null ? originRequestPolicyConfig.build() : null;
        }

        @Override
        public final Builder originRequestPolicyConfig(OriginRequestPolicyConfig originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOriginRequestPolicyRequest build() {
            return new CreateOriginRequestPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOriginRequestPolicyRequest> {
        public Builder originRequestPolicyConfig(OriginRequestPolicyConfig var1);

        default public Builder originRequestPolicyConfig(Consumer<OriginRequestPolicyConfig.Builder> originRequestPolicyConfig) {
            return this.originRequestPolicyConfig((OriginRequestPolicyConfig)((OriginRequestPolicyConfig.Builder)OriginRequestPolicyConfig.builder().applyMutation(originRequestPolicyConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

