/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.OriginGroupFailoverCriteria;
import software.amazon.awssdk.services.cloudfront.model.OriginGroupMembers;
import software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginGroup> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(OriginGroup.getter(OriginGroup::id)).setter(OriginGroup.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<OriginGroupFailoverCriteria> FAILOVER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailoverCriteria").getter(OriginGroup.getter(OriginGroup::failoverCriteria)).setter(OriginGroup.setter(Builder::failoverCriteria)).constructor(OriginGroupFailoverCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailoverCriteria").unmarshallLocationName("FailoverCriteria").build()}).build();
    private static final SdkField<OriginGroupMembers> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Members").getter(OriginGroup.getter(OriginGroup::members)).setter(OriginGroup.setter(Builder::members)).constructor(OriginGroupMembers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").unmarshallLocationName("Members").build()}).build();
    private static final SdkField<String> SELECTION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionCriteria").getter(OriginGroup.getter(OriginGroup::selectionCriteriaAsString)).setter(OriginGroup.setter(Builder::selectionCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionCriteria").unmarshallLocationName("SelectionCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FAILOVER_CRITERIA_FIELD, MEMBERS_FIELD, SELECTION_CRITERIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OriginGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final OriginGroupFailoverCriteria failoverCriteria;
    private final OriginGroupMembers members;
    private final String selectionCriteria;

    private OriginGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.failoverCriteria = builder.failoverCriteria;
        this.members = builder.members;
        this.selectionCriteria = builder.selectionCriteria;
    }

    public final String id() {
        return this.id;
    }

    public final OriginGroupFailoverCriteria failoverCriteria() {
        return this.failoverCriteria;
    }

    public final OriginGroupMembers members() {
        return this.members;
    }

    public final OriginGroupSelectionCriteria selectionCriteria() {
        return OriginGroupSelectionCriteria.fromValue(this.selectionCriteria);
    }

    public final String selectionCriteriaAsString() {
        return this.selectionCriteria;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.failoverCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.members());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionCriteriaAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginGroup)) {
            return false;
        }
        OriginGroup other = (OriginGroup)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.failoverCriteria(), other.failoverCriteria()) && Objects.equals(this.members(), other.members()) && Objects.equals(this.selectionCriteriaAsString(), other.selectionCriteriaAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OriginGroup").add("Id", (Object)this.id()).add("FailoverCriteria", (Object)this.failoverCriteria()).add("Members", (Object)this.members()).add("SelectionCriteria", (Object)this.selectionCriteriaAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "FailoverCriteria": {
                return Optional.ofNullable(clazz.cast(this.failoverCriteria()));
            }
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "SelectionCriteria": {
                return Optional.ofNullable(clazz.cast(this.selectionCriteriaAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("FailoverCriteria", FAILOVER_CRITERIA_FIELD);
        map.put("Members", MEMBERS_FIELD);
        map.put("SelectionCriteria", SELECTION_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OriginGroup, T> g) {
        return obj -> g.apply((OriginGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private OriginGroupFailoverCriteria failoverCriteria;
        private OriginGroupMembers members;
        private String selectionCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginGroup model) {
            this.id(model.id);
            this.failoverCriteria(model.failoverCriteria);
            this.members(model.members);
            this.selectionCriteria(model.selectionCriteria);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final OriginGroupFailoverCriteria.Builder getFailoverCriteria() {
            return this.failoverCriteria != null ? this.failoverCriteria.toBuilder() : null;
        }

        public final void setFailoverCriteria(OriginGroupFailoverCriteria.BuilderImpl failoverCriteria) {
            this.failoverCriteria = failoverCriteria != null ? failoverCriteria.build() : null;
        }

        @Override
        public final Builder failoverCriteria(OriginGroupFailoverCriteria failoverCriteria) {
            this.failoverCriteria = failoverCriteria;
            return this;
        }

        public final OriginGroupMembers.Builder getMembers() {
            return this.members != null ? this.members.toBuilder() : null;
        }

        public final void setMembers(OriginGroupMembers.BuilderImpl members) {
            this.members = members != null ? members.build() : null;
        }

        @Override
        public final Builder members(OriginGroupMembers members) {
            this.members = members;
            return this;
        }

        public final String getSelectionCriteria() {
            return this.selectionCriteria;
        }

        public final void setSelectionCriteria(String selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
        }

        @Override
        public final Builder selectionCriteria(String selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
            return this;
        }

        @Override
        public final Builder selectionCriteria(OriginGroupSelectionCriteria selectionCriteria) {
            this.selectionCriteria(selectionCriteria == null ? null : selectionCriteria.toString());
            return this;
        }

        public OriginGroup build() {
            return new OriginGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginGroup> {
        public Builder id(String var1);

        public Builder failoverCriteria(OriginGroupFailoverCriteria var1);

        default public Builder failoverCriteria(Consumer<OriginGroupFailoverCriteria.Builder> failoverCriteria) {
            return this.failoverCriteria((OriginGroupFailoverCriteria)((OriginGroupFailoverCriteria.Builder)OriginGroupFailoverCriteria.builder().applyMutation(failoverCriteria)).build());
        }

        public Builder members(OriginGroupMembers var1);

        default public Builder members(Consumer<OriginGroupMembers.Builder> members) {
            return this.members((OriginGroupMembers)((OriginGroupMembers.Builder)OriginGroupMembers.builder().applyMutation(members)).build());
        }

        public Builder selectionCriteria(String var1);

        public Builder selectionCriteria(OriginGroupSelectionCriteria var1);
    }
}

