/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.waiters.internal;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterState;

@SdkInternalApi
public final class WaitersRuntime {
    private static final String FAILURE_MESSAGE_FORMAT_FOR_STATUS_MATCHER = "A waiter acceptor was matched on HTTP response status code (%d) and transitioned the waiter to failure state";
    public static final List<WaiterAcceptor<Object>> DEFAULT_ACCEPTORS = Collections.unmodifiableList(WaitersRuntime.defaultAcceptors());

    private WaitersRuntime() {
    }

    private static List<WaiterAcceptor<Object>> defaultAcceptors() {
        return Collections.singletonList(WaitersRuntime.retryOnUnmatchedResponseWaiter());
    }

    private static WaiterAcceptor<Object> retryOnUnmatchedResponseWaiter() {
        return WaiterAcceptor.retryOnResponseAcceptor(r -> true);
    }

    public static final class ResponseStatusAcceptor
    implements WaiterAcceptor<SdkResponse> {
        private final int statusCode;
        private final WaiterState waiterState;

        public ResponseStatusAcceptor(int statusCode, WaiterState waiterState) {
            this.statusCode = statusCode;
            this.waiterState = waiterState;
        }

        public WaiterState waiterState() {
            return this.waiterState;
        }

        public boolean matches(SdkResponse response) {
            return response.sdkHttpResponse() != null && response.sdkHttpResponse().statusCode() == this.statusCode;
        }

        public boolean matches(Throwable throwable) {
            if (throwable instanceof SdkServiceException) {
                return ((SdkServiceException)throwable).statusCode() == this.statusCode;
            }
            return false;
        }

        public Optional<String> message() {
            return this.waiterState == WaiterState.FAILURE ? Optional.of(String.format(WaitersRuntime.FAILURE_MESSAGE_FORMAT_FOR_STATUS_MATCHER, this.statusCode)) : Optional.empty();
        }
    }
}

