/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorKeyLabelsCopier;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorsCopier;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInsightRuleReportResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, GetInsightRuleReportResponse> {
    private static final SdkField<List<String>> KEY_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::keyLabels)).setter(GetInsightRuleReportResponse.setter(Builder::keyLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGGREGATION_STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::aggregationStatistic)).setter(GetInsightRuleReportResponse.setter(Builder::aggregationStatistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationStatistic").build()}).build();
    private static final SdkField<Double> AGGREGATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::aggregateValue)).setter(GetInsightRuleReportResponse.setter(Builder::aggregateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateValue").build()}).build();
    private static final SdkField<Long> APPROXIMATE_UNIQUE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::approximateUniqueCount)).setter(GetInsightRuleReportResponse.setter(Builder::approximateUniqueCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateUniqueCount").build()}).build();
    private static final SdkField<List<InsightRuleContributor>> CONTRIBUTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::contributors)).setter(GetInsightRuleReportResponse.setter(Builder::contributors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contributors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightRuleContributor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InsightRuleMetricDatapoint>> METRIC_DATAPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::metricDatapoints)).setter(GetInsightRuleReportResponse.setter(Builder::metricDatapoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDatapoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightRuleMetricDatapoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_LABELS_FIELD, AGGREGATION_STATISTIC_FIELD, AGGREGATE_VALUE_FIELD, APPROXIMATE_UNIQUE_COUNT_FIELD, CONTRIBUTORS_FIELD, METRIC_DATAPOINTS_FIELD));
    private final List<String> keyLabels;
    private final String aggregationStatistic;
    private final Double aggregateValue;
    private final Long approximateUniqueCount;
    private final List<InsightRuleContributor> contributors;
    private final List<InsightRuleMetricDatapoint> metricDatapoints;

    private GetInsightRuleReportResponse(BuilderImpl builder) {
        super(builder);
        this.keyLabels = builder.keyLabels;
        this.aggregationStatistic = builder.aggregationStatistic;
        this.aggregateValue = builder.aggregateValue;
        this.approximateUniqueCount = builder.approximateUniqueCount;
        this.contributors = builder.contributors;
        this.metricDatapoints = builder.metricDatapoints;
    }

    public boolean hasKeyLabels() {
        return this.keyLabels != null && !(this.keyLabels instanceof SdkAutoConstructList);
    }

    public List<String> keyLabels() {
        return this.keyLabels;
    }

    public String aggregationStatistic() {
        return this.aggregationStatistic;
    }

    public Double aggregateValue() {
        return this.aggregateValue;
    }

    public Long approximateUniqueCount() {
        return this.approximateUniqueCount;
    }

    public boolean hasContributors() {
        return this.contributors != null && !(this.contributors instanceof SdkAutoConstructList);
    }

    public List<InsightRuleContributor> contributors() {
        return this.contributors;
    }

    public boolean hasMetricDatapoints() {
        return this.metricDatapoints != null && !(this.metricDatapoints instanceof SdkAutoConstructList);
    }

    public List<InsightRuleMetricDatapoint> metricDatapoints() {
        return this.metricDatapoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateUniqueCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.contributors());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDatapoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightRuleReportResponse)) {
            return false;
        }
        GetInsightRuleReportResponse other = (GetInsightRuleReportResponse)((Object)obj);
        return Objects.equals(this.keyLabels(), other.keyLabels()) && Objects.equals(this.aggregationStatistic(), other.aggregationStatistic()) && Objects.equals(this.aggregateValue(), other.aggregateValue()) && Objects.equals(this.approximateUniqueCount(), other.approximateUniqueCount()) && Objects.equals(this.contributors(), other.contributors()) && Objects.equals(this.metricDatapoints(), other.metricDatapoints());
    }

    public String toString() {
        return ToString.builder((String)"GetInsightRuleReportResponse").add("KeyLabels", this.keyLabels()).add("AggregationStatistic", (Object)this.aggregationStatistic()).add("AggregateValue", (Object)this.aggregateValue()).add("ApproximateUniqueCount", (Object)this.approximateUniqueCount()).add("Contributors", this.contributors()).add("MetricDatapoints", this.metricDatapoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyLabels": {
                return Optional.ofNullable(clazz.cast(this.keyLabels()));
            }
            case "AggregationStatistic": {
                return Optional.ofNullable(clazz.cast(this.aggregationStatistic()));
            }
            case "AggregateValue": {
                return Optional.ofNullable(clazz.cast(this.aggregateValue()));
            }
            case "ApproximateUniqueCount": {
                return Optional.ofNullable(clazz.cast(this.approximateUniqueCount()));
            }
            case "Contributors": {
                return Optional.ofNullable(clazz.cast(this.contributors()));
            }
            case "MetricDatapoints": {
                return Optional.ofNullable(clazz.cast(this.metricDatapoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightRuleReportResponse, T> g) {
        return obj -> g.apply((GetInsightRuleReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<String> keyLabels = DefaultSdkAutoConstructList.getInstance();
        private String aggregationStatistic;
        private Double aggregateValue;
        private Long approximateUniqueCount;
        private List<InsightRuleContributor> contributors = DefaultSdkAutoConstructList.getInstance();
        private List<InsightRuleMetricDatapoint> metricDatapoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightRuleReportResponse model) {
            super(model);
            this.keyLabels(model.keyLabels);
            this.aggregationStatistic(model.aggregationStatistic);
            this.aggregateValue(model.aggregateValue);
            this.approximateUniqueCount(model.approximateUniqueCount);
            this.contributors(model.contributors);
            this.metricDatapoints(model.metricDatapoints);
        }

        public final Collection<String> getKeyLabels() {
            return this.keyLabels;
        }

        @Override
        public final Builder keyLabels(Collection<String> keyLabels) {
            this.keyLabels = InsightRuleContributorKeyLabelsCopier.copy(keyLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyLabels(String ... keyLabels) {
            this.keyLabels(Arrays.asList(keyLabels));
            return this;
        }

        public final void setKeyLabels(Collection<String> keyLabels) {
            this.keyLabels = InsightRuleContributorKeyLabelsCopier.copy(keyLabels);
        }

        public final String getAggregationStatistic() {
            return this.aggregationStatistic;
        }

        @Override
        public final Builder aggregationStatistic(String aggregationStatistic) {
            this.aggregationStatistic = aggregationStatistic;
            return this;
        }

        public final void setAggregationStatistic(String aggregationStatistic) {
            this.aggregationStatistic = aggregationStatistic;
        }

        public final Double getAggregateValue() {
            return this.aggregateValue;
        }

        @Override
        public final Builder aggregateValue(Double aggregateValue) {
            this.aggregateValue = aggregateValue;
            return this;
        }

        public final void setAggregateValue(Double aggregateValue) {
            this.aggregateValue = aggregateValue;
        }

        public final Long getApproximateUniqueCount() {
            return this.approximateUniqueCount;
        }

        @Override
        public final Builder approximateUniqueCount(Long approximateUniqueCount) {
            this.approximateUniqueCount = approximateUniqueCount;
            return this;
        }

        public final void setApproximateUniqueCount(Long approximateUniqueCount) {
            this.approximateUniqueCount = approximateUniqueCount;
        }

        public final Collection<InsightRuleContributor.Builder> getContributors() {
            return this.contributors != null ? (Collection)this.contributors.stream().map(InsightRuleContributor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contributors(Collection<InsightRuleContributor> contributors) {
            this.contributors = InsightRuleContributorsCopier.copy(contributors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributors(InsightRuleContributor ... contributors) {
            this.contributors(Arrays.asList(contributors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributors(Consumer<InsightRuleContributor.Builder> ... contributors) {
            this.contributors(Stream.of(contributors).map(c -> (InsightRuleContributor)((InsightRuleContributor.Builder)InsightRuleContributor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContributors(Collection<InsightRuleContributor.BuilderImpl> contributors) {
            this.contributors = InsightRuleContributorsCopier.copyFromBuilder(contributors);
        }

        public final Collection<InsightRuleMetricDatapoint.Builder> getMetricDatapoints() {
            return this.metricDatapoints != null ? (Collection)this.metricDatapoints.stream().map(InsightRuleMetricDatapoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricDatapoints(Collection<InsightRuleMetricDatapoint> metricDatapoints) {
            this.metricDatapoints = InsightRuleMetricDatapointsCopier.copy(metricDatapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDatapoints(InsightRuleMetricDatapoint ... metricDatapoints) {
            this.metricDatapoints(Arrays.asList(metricDatapoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDatapoints(Consumer<InsightRuleMetricDatapoint.Builder> ... metricDatapoints) {
            this.metricDatapoints(Stream.of(metricDatapoints).map(c -> (InsightRuleMetricDatapoint)((InsightRuleMetricDatapoint.Builder)InsightRuleMetricDatapoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricDatapoints(Collection<InsightRuleMetricDatapoint.BuilderImpl> metricDatapoints) {
            this.metricDatapoints = InsightRuleMetricDatapointsCopier.copyFromBuilder(metricDatapoints);
        }

        @Override
        public GetInsightRuleReportResponse build() {
            return new GetInsightRuleReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInsightRuleReportResponse> {
        public Builder keyLabels(Collection<String> var1);

        public Builder keyLabels(String ... var1);

        public Builder aggregationStatistic(String var1);

        public Builder aggregateValue(Double var1);

        public Builder approximateUniqueCount(Long var1);

        public Builder contributors(Collection<InsightRuleContributor> var1);

        public Builder contributors(InsightRuleContributor ... var1);

        public Builder contributors(Consumer<InsightRuleContributor.Builder> ... var1);

        public Builder metricDatapoints(Collection<InsightRuleMetricDatapoint> var1);

        public Builder metricDatapoints(InsightRuleMetricDatapoint ... var1);

        public Builder metricDatapoints(Consumer<InsightRuleMetricDatapoint.Builder> ... var1);
    }
}

