/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.ExtendedStatisticsCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.services.cloudwatch.model.StatisticsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricStatisticsRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, GetMetricStatisticsRequest> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(GetMetricStatisticsRequest.getter(GetMetricStatisticsRequest::namespace)).setter(GetMetricStatisticsRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(GetMetricStatisticsRequest.getter(GetMetricStatisticsRequest::metricName)).setter(GetMetricStatisticsRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(GetMetricStatisticsRequest.getter(GetMetricStatisticsRequest::dimensions)).setter(GetMetricStatisticsRequest.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetMetricStatisticsRequest.getter(GetMetricStatisticsRequest::startTime)).setter(GetMetricStatisticsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetMetricStatisticsRequest.getter(GetMetricStatisticsRequest::endTime)).setter(GetMetricStatisticsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(GetMetricStatisticsRequest.getter(GetMetricStatisticsRequest::period)).setter(GetMetricStatisticsRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statistics").getter(GetMetricStatisticsRequest.getter(GetMetricStatisticsRequest::statisticsAsStrings)).setter(GetMetricStatisticsRequest.setter(Builder::statisticsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXTENDED_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExtendedStatistics").getter(GetMetricStatisticsRequest.getter(GetMetricStatisticsRequest::extendedStatistics)).setter(GetMetricStatisticsRequest.setter(Builder::extendedStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedStatistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(GetMetricStatisticsRequest.getter(GetMetricStatisticsRequest::unitAsString)).setter(GetMetricStatisticsRequest.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, METRIC_NAME_FIELD, DIMENSIONS_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERIOD_FIELD, STATISTICS_FIELD, EXTENDED_STATISTICS_FIELD, UNIT_FIELD));
    private final String namespace;
    private final String metricName;
    private final List<Dimension> dimensions;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer period;
    private final List<String> statistics;
    private final List<String> extendedStatistics;
    private final String unit;

    private GetMetricStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.statistics = builder.statistics;
        this.extendedStatistics = builder.extendedStatistics;
        this.unit = builder.unit;
    }

    public String namespace() {
        return this.namespace;
    }

    public String metricName() {
        return this.metricName;
    }

    public boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Integer period() {
        return this.period;
    }

    public List<Statistic> statistics() {
        return StatisticsCopier.copyStringToEnum(this.statistics);
    }

    public boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public List<String> statisticsAsStrings() {
        return this.statistics;
    }

    public boolean hasExtendedStatistics() {
        return this.extendedStatistics != null && !(this.extendedStatistics instanceof SdkAutoConstructList);
    }

    public List<String> extendedStatistics() {
        return this.extendedStatistics;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatistics() ? this.statisticsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtendedStatistics() ? this.extendedStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsRequest)) {
            return false;
        }
        GetMetricStatisticsRequest other = (GetMetricStatisticsRequest)((Object)obj);
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.metricName(), other.metricName()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.period(), other.period()) && this.hasStatistics() == other.hasStatistics() && Objects.equals(this.statisticsAsStrings(), other.statisticsAsStrings()) && this.hasExtendedStatistics() == other.hasExtendedStatistics() && Objects.equals(this.extendedStatistics(), other.extendedStatistics()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetMetricStatisticsRequest").add("Namespace", (Object)this.namespace()).add("MetricName", (Object)this.metricName()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Period", (Object)this.period()).add("Statistics", this.hasStatistics() ? this.statisticsAsStrings() : null).add("ExtendedStatistics", this.hasExtendedStatistics() ? this.extendedStatistics() : null).add("Unit", (Object)this.unitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statisticsAsStrings()));
            }
            case "ExtendedStatistics": {
                return Optional.ofNullable(clazz.cast(this.extendedStatistics()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricStatisticsRequest, T> g) {
        return obj -> g.apply((GetMetricStatisticsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String namespace;
        private String metricName;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private Integer period;
        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();
        private List<String> extendedStatistics = DefaultSdkAutoConstructList.getInstance();
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStatisticsRequest model) {
            super(model);
            this.namespace(model.namespace);
            this.metricName(model.metricName);
            this.dimensions(model.dimensions);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.period(model.period);
            this.statisticsWithStrings(model.statistics);
            this.extendedStatistics(model.extendedStatistics);
            this.unit(model.unit);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Dimension.Builder> getDimensions() {
            if (this.dimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(Dimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Collection<String> getStatistics() {
            if (this.statistics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statistics;
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String ... statistics) {
            this.statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<Statistic> statistics) {
            this.statistics = StatisticsCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Statistic ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
        }

        public final Collection<String> getExtendedStatistics() {
            if (this.extendedStatistics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.extendedStatistics;
        }

        @Override
        public final Builder extendedStatistics(Collection<String> extendedStatistics) {
            this.extendedStatistics = ExtendedStatisticsCopier.copy(extendedStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedStatistics(String ... extendedStatistics) {
            this.extendedStatistics(Arrays.asList(extendedStatistics));
            return this;
        }

        public final void setExtendedStatistics(Collection<String> extendedStatistics) {
            this.extendedStatistics = ExtendedStatisticsCopier.copy(extendedStatistics);
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricStatisticsRequest build() {
            return new GetMetricStatisticsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetricStatisticsRequest> {
        public Builder namespace(String var1);

        public Builder metricName(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder period(Integer var1);

        public Builder statisticsWithStrings(Collection<String> var1);

        public Builder statisticsWithStrings(String ... var1);

        public Builder statistics(Collection<Statistic> var1);

        public Builder statistics(Statistic ... var1);

        public Builder extendedStatistics(Collection<String> var1);

        public Builder extendedStatistics(String ... var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

