/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.RepositoryNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAllowedRepositoriesForGroupResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, ListAllowedRepositoriesForGroupResponse> {
    private static final SdkField<List<String>> ALLOWED_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedRepositories").getter(ListAllowedRepositoriesForGroupResponse.getter(ListAllowedRepositoriesForGroupResponse::allowedRepositories)).setter(ListAllowedRepositoriesForGroupResponse.setter(Builder::allowedRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedRepositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAllowedRepositoriesForGroupResponse.getter(ListAllowedRepositoriesForGroupResponse::nextToken)).setter(ListAllowedRepositoriesForGroupResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_REPOSITORIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAllowedRepositoriesForGroupResponse.memberNameToFieldInitializer();
    private final List<String> allowedRepositories;
    private final String nextToken;

    private ListAllowedRepositoriesForGroupResponse(BuilderImpl builder) {
        super(builder);
        this.allowedRepositories = builder.allowedRepositories;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAllowedRepositories() {
        return this.allowedRepositories != null && !(this.allowedRepositories instanceof SdkAutoConstructList);
    }

    public final List<String> allowedRepositories() {
        return this.allowedRepositories;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedRepositories() ? this.allowedRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAllowedRepositoriesForGroupResponse)) {
            return false;
        }
        ListAllowedRepositoriesForGroupResponse other = (ListAllowedRepositoriesForGroupResponse)((Object)obj);
        return this.hasAllowedRepositories() == other.hasAllowedRepositories() && Objects.equals(this.allowedRepositories(), other.allowedRepositories()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAllowedRepositoriesForGroupResponse").add("AllowedRepositories", this.hasAllowedRepositories() ? this.allowedRepositories() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedRepositories": {
                return Optional.ofNullable(clazz.cast(this.allowedRepositories()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowedRepositories", ALLOWED_REPOSITORIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAllowedRepositoriesForGroupResponse, T> g) {
        return obj -> g.apply((ListAllowedRepositoriesForGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private List<String> allowedRepositories = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAllowedRepositoriesForGroupResponse model) {
            super(model);
            this.allowedRepositories(model.allowedRepositories);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAllowedRepositories() {
            if (this.allowedRepositories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedRepositories;
        }

        public final void setAllowedRepositories(Collection<String> allowedRepositories) {
            this.allowedRepositories = RepositoryNameListCopier.copy(allowedRepositories);
        }

        @Override
        public final Builder allowedRepositories(Collection<String> allowedRepositories) {
            this.allowedRepositories = RepositoryNameListCopier.copy(allowedRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedRepositories(String ... allowedRepositories) {
            this.allowedRepositories(Arrays.asList(allowedRepositories));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAllowedRepositoriesForGroupResponse build() {
            return new ListAllowedRepositoriesForGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAllowedRepositoriesForGroupResponse> {
        public Builder allowedRepositories(Collection<String> var1);

        public Builder allowedRepositories(String ... var1);

        public Builder nextToken(String var1);
    }
}

