/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageSummary;

public class ListPackagesPublisher
implements SdkPublisher<ListPackagesResponse> {
    private final CodeartifactAsyncClient client;
    private final ListPackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPackagesPublisher(CodeartifactAsyncClient client, ListPackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPackagesPublisher(CodeartifactAsyncClient client, ListPackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PackageSummary> packages() {
        Function<ListPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.packages() != null) {
                return response.packages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPackagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPackagesResponseFetcher
    implements AsyncPageFetcher<ListPackagesResponse> {
        private ListPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPackagesResponse> nextPage(ListPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListPackagesPublisher.this.client.listPackages(ListPackagesPublisher.this.firstRequest);
            }
            return ListPackagesPublisher.this.client.listPackages((ListPackagesRequest)((Object)ListPackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

