/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBuildBatchesRequest extends CodeBuildRequest implements
        ToCopyableBuilder<ListBuildBatchesRequest.Builder, ListBuildBatchesRequest> {
    private static final SdkField<BuildBatchFilter> FILTER_FIELD = SdkField.<BuildBatchFilter> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(ListBuildBatchesRequest::filter)).setter(setter(Builder::filter))
            .constructor(BuildBatchFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListBuildBatchesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListBuildBatchesRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBuildBatchesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            MAX_RESULTS_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD));

    private final BuildBatchFilter filter;

    private final Integer maxResults;

    private final String sortOrder;

    private final String nextToken;

    private ListBuildBatchesRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A <code>BuildBatchFilter</code> object that specifies the filters for the search.
     * </p>
     * 
     * @return A <code>BuildBatchFilter</code> object that specifies the filters for the search.
     */
    public final BuildBatchFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies the sort order of the returned items. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies the sort order of the returned items. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.
     *         </p>
     *         </li>
     * @see SortOrderType
     */
    public final SortOrderType sortOrder() {
        return SortOrderType.fromValue(sortOrder);
    }

    /**
     * <p>
     * Specifies the sort order of the returned items. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies the sort order of the returned items. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.
     *         </p>
     *         </li>
     * @see SortOrderType
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous call to <code>ListBuildBatches</code>. This specifies
     * the next item to return. To return the beginning of the list, exclude this parameter.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned from a previous call to <code>ListBuildBatches</code>. This
     *         specifies the next item to return. To return the beginning of the list, exclude this parameter.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildBatchesRequest)) {
            return false;
        }
        ListBuildBatchesRequest other = (ListBuildBatchesRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBuildBatchesRequest").add("Filter", filter()).add("MaxResults", maxResults())
                .add("SortOrder", sortOrderAsString()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBuildBatchesRequest, T> g) {
        return obj -> g.apply((ListBuildBatchesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListBuildBatchesRequest> {
        /**
         * <p>
         * A <code>BuildBatchFilter</code> object that specifies the filters for the search.
         * </p>
         * 
         * @param filter
         *        A <code>BuildBatchFilter</code> object that specifies the filters for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(BuildBatchFilter filter);

        /**
         * <p>
         * A <code>BuildBatchFilter</code> object that specifies the filters for the search.
         * </p>
         * This is a convenience method that creates an instance of the {@link BuildBatchFilter.Builder} avoiding the
         * need to create one manually via {@link BuildBatchFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BuildBatchFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(BuildBatchFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link BuildBatchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(BuildBatchFilter)
         */
        default Builder filter(Consumer<BuildBatchFilter.Builder> filter) {
            return filter(BuildBatchFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies the sort order of the returned items. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sortOrder
         *        Specifies the sort order of the returned items. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.
         *        </p>
         *        </li>
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Specifies the sort order of the returned items. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sortOrder
         *        Specifies the sort order of the returned items. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.
         *        </p>
         *        </li>
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(SortOrderType sortOrder);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous call to <code>ListBuildBatches</code>. This
         * specifies the next item to return. To return the beginning of the list, exclude this parameter.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous call to <code>ListBuildBatches</code>. This
         *        specifies the next item to return. To return the beginning of the list, exclude this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private BuildBatchFilter filter;

        private Integer maxResults;

        private String sortOrder;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildBatchesRequest model) {
            super(model);
            filter(model.filter);
            maxResults(model.maxResults);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
        }

        public final BuildBatchFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(BuildBatchFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(BuildBatchFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBuildBatchesRequest build() {
            return new ListBuildBatchesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
