/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum;
import software.amazon.awssdk.services.codecommit.model.ConflictResolutionStrategyTypeEnum;
import software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMergeConflictsRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, DescribeMergeConflictsRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(DescribeMergeConflictsRequest.getter(DescribeMergeConflictsRequest::repositoryName)).setter(DescribeMergeConflictsRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCommitSpecifier").getter(DescribeMergeConflictsRequest.getter(DescribeMergeConflictsRequest::destinationCommitSpecifier)).setter(DescribeMergeConflictsRequest.setter(Builder::destinationCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCommitSpecifier").getter(DescribeMergeConflictsRequest.getter(DescribeMergeConflictsRequest::sourceCommitSpecifier)).setter(DescribeMergeConflictsRequest.setter(Builder::sourceCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build()}).build();
    private static final SdkField<String> MERGE_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mergeOption").getter(DescribeMergeConflictsRequest.getter(DescribeMergeConflictsRequest::mergeOptionAsString)).setter(DescribeMergeConflictsRequest.setter(Builder::mergeOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOption").build()}).build();
    private static final SdkField<Integer> MAX_MERGE_HUNKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxMergeHunks").getter(DescribeMergeConflictsRequest.getter(DescribeMergeConflictsRequest::maxMergeHunks)).setter(DescribeMergeConflictsRequest.setter(Builder::maxMergeHunks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxMergeHunks").build()}).build();
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePath").getter(DescribeMergeConflictsRequest.getter(DescribeMergeConflictsRequest::filePath)).setter(DescribeMergeConflictsRequest.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<String> CONFLICT_DETAIL_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conflictDetailLevel").getter(DescribeMergeConflictsRequest.getter(DescribeMergeConflictsRequest::conflictDetailLevelAsString)).setter(DescribeMergeConflictsRequest.setter(Builder::conflictDetailLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetailLevel").build()}).build();
    private static final SdkField<String> CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conflictResolutionStrategy").getter(DescribeMergeConflictsRequest.getter(DescribeMergeConflictsRequest::conflictResolutionStrategyAsString)).setter(DescribeMergeConflictsRequest.setter(Builder::conflictResolutionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolutionStrategy").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeMergeConflictsRequest.getter(DescribeMergeConflictsRequest::nextToken)).setter(DescribeMergeConflictsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, DESTINATION_COMMIT_SPECIFIER_FIELD, SOURCE_COMMIT_SPECIFIER_FIELD, MERGE_OPTION_FIELD, MAX_MERGE_HUNKS_FIELD, FILE_PATH_FIELD, CONFLICT_DETAIL_LEVEL_FIELD, CONFLICT_RESOLUTION_STRATEGY_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMergeConflictsRequest.memberNameToFieldInitializer();
    private final String repositoryName;
    private final String destinationCommitSpecifier;
    private final String sourceCommitSpecifier;
    private final String mergeOption;
    private final Integer maxMergeHunks;
    private final String filePath;
    private final String conflictDetailLevel;
    private final String conflictResolutionStrategy;
    private final String nextToken;

    private DescribeMergeConflictsRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.mergeOption = builder.mergeOption;
        this.maxMergeHunks = builder.maxMergeHunks;
        this.filePath = builder.filePath;
        this.conflictDetailLevel = builder.conflictDetailLevel;
        this.conflictResolutionStrategy = builder.conflictResolutionStrategy;
        this.nextToken = builder.nextToken;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String destinationCommitSpecifier() {
        return this.destinationCommitSpecifier;
    }

    public final String sourceCommitSpecifier() {
        return this.sourceCommitSpecifier;
    }

    public final MergeOptionTypeEnum mergeOption() {
        return MergeOptionTypeEnum.fromValue(this.mergeOption);
    }

    public final String mergeOptionAsString() {
        return this.mergeOption;
    }

    public final Integer maxMergeHunks() {
        return this.maxMergeHunks;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final ConflictDetailLevelTypeEnum conflictDetailLevel() {
        return ConflictDetailLevelTypeEnum.fromValue(this.conflictDetailLevel);
    }

    public final String conflictDetailLevelAsString() {
        return this.conflictDetailLevel;
    }

    public final ConflictResolutionStrategyTypeEnum conflictResolutionStrategy() {
        return ConflictResolutionStrategyTypeEnum.fromValue(this.conflictResolutionStrategy);
    }

    public final String conflictResolutionStrategyAsString() {
        return this.conflictResolutionStrategy;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxMergeHunks());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictDetailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictResolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMergeConflictsRequest)) {
            return false;
        }
        DescribeMergeConflictsRequest other = (DescribeMergeConflictsRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.destinationCommitSpecifier(), other.destinationCommitSpecifier()) && Objects.equals(this.sourceCommitSpecifier(), other.sourceCommitSpecifier()) && Objects.equals(this.mergeOptionAsString(), other.mergeOptionAsString()) && Objects.equals(this.maxMergeHunks(), other.maxMergeHunks()) && Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.conflictDetailLevelAsString(), other.conflictDetailLevelAsString()) && Objects.equals(this.conflictResolutionStrategyAsString(), other.conflictResolutionStrategyAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMergeConflictsRequest").add("RepositoryName", (Object)this.repositoryName()).add("DestinationCommitSpecifier", (Object)this.destinationCommitSpecifier()).add("SourceCommitSpecifier", (Object)this.sourceCommitSpecifier()).add("MergeOption", (Object)this.mergeOptionAsString()).add("MaxMergeHunks", (Object)this.maxMergeHunks()).add("FilePath", (Object)this.filePath()).add("ConflictDetailLevel", (Object)this.conflictDetailLevelAsString()).add("ConflictResolutionStrategy", (Object)this.conflictResolutionStrategyAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "destinationCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitSpecifier()));
            }
            case "sourceCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitSpecifier()));
            }
            case "mergeOption": {
                return Optional.ofNullable(clazz.cast(this.mergeOptionAsString()));
            }
            case "maxMergeHunks": {
                return Optional.ofNullable(clazz.cast(this.maxMergeHunks()));
            }
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "conflictDetailLevel": {
                return Optional.ofNullable(clazz.cast(this.conflictDetailLevelAsString()));
            }
            case "conflictResolutionStrategy": {
                return Optional.ofNullable(clazz.cast(this.conflictResolutionStrategyAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("destinationCommitSpecifier", DESTINATION_COMMIT_SPECIFIER_FIELD);
        map.put("sourceCommitSpecifier", SOURCE_COMMIT_SPECIFIER_FIELD);
        map.put("mergeOption", MERGE_OPTION_FIELD);
        map.put("maxMergeHunks", MAX_MERGE_HUNKS_FIELD);
        map.put("filePath", FILE_PATH_FIELD);
        map.put("conflictDetailLevel", CONFLICT_DETAIL_LEVEL_FIELD);
        map.put("conflictResolutionStrategy", CONFLICT_RESOLUTION_STRATEGY_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMergeConflictsRequest, T> g) {
        return obj -> g.apply((DescribeMergeConflictsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String destinationCommitSpecifier;
        private String sourceCommitSpecifier;
        private String mergeOption;
        private Integer maxMergeHunks;
        private String filePath;
        private String conflictDetailLevel;
        private String conflictResolutionStrategy;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMergeConflictsRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.destinationCommitSpecifier(model.destinationCommitSpecifier);
            this.sourceCommitSpecifier(model.sourceCommitSpecifier);
            this.mergeOption(model.mergeOption);
            this.maxMergeHunks(model.maxMergeHunks);
            this.filePath(model.filePath);
            this.conflictDetailLevel(model.conflictDetailLevel);
            this.conflictResolutionStrategy(model.conflictResolutionStrategy);
            this.nextToken(model.nextToken);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getDestinationCommitSpecifier() {
            return this.destinationCommitSpecifier;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final String getSourceCommitSpecifier() {
            return this.sourceCommitSpecifier;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final String getMergeOption() {
            return this.mergeOption;
        }

        public final void setMergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
        }

        @Override
        public final Builder mergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
            return this;
        }

        @Override
        public final Builder mergeOption(MergeOptionTypeEnum mergeOption) {
            this.mergeOption(mergeOption == null ? null : mergeOption.toString());
            return this;
        }

        public final Integer getMaxMergeHunks() {
            return this.maxMergeHunks;
        }

        public final void setMaxMergeHunks(Integer maxMergeHunks) {
            this.maxMergeHunks = maxMergeHunks;
        }

        @Override
        public final Builder maxMergeHunks(Integer maxMergeHunks) {
            this.maxMergeHunks = maxMergeHunks;
            return this;
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getConflictDetailLevel() {
            return this.conflictDetailLevel;
        }

        public final void setConflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
        }

        @Override
        public final Builder conflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
            return this;
        }

        @Override
        public final Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel) {
            this.conflictDetailLevel(conflictDetailLevel == null ? null : conflictDetailLevel.toString());
            return this;
        }

        public final String getConflictResolutionStrategy() {
            return this.conflictResolutionStrategy;
        }

        public final void setConflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
        }

        @Override
        public final Builder conflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy) {
            this.conflictResolutionStrategy(conflictResolutionStrategy == null ? null : conflictResolutionStrategy.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMergeConflictsRequest build() {
            return new DescribeMergeConflictsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMergeConflictsRequest> {
        public Builder repositoryName(String var1);

        public Builder destinationCommitSpecifier(String var1);

        public Builder sourceCommitSpecifier(String var1);

        public Builder mergeOption(String var1);

        public Builder mergeOption(MergeOptionTypeEnum var1);

        public Builder maxMergeHunks(Integer var1);

        public Builder filePath(String var1);

        public Builder conflictDetailLevel(String var1);

        public Builder conflictDetailLevel(ConflictDetailLevelTypeEnum var1);

        public Builder conflictResolutionStrategy(String var1);

        public Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

