/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRepositoryEncryptionKeyResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, UpdateRepositoryEncryptionKeyResponse> {
    private static final SdkField<String> REPOSITORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryId").getter(UpdateRepositoryEncryptionKeyResponse.getter(UpdateRepositoryEncryptionKeyResponse::repositoryId)).setter(UpdateRepositoryEncryptionKeyResponse.setter(Builder::repositoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryId").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(UpdateRepositoryEncryptionKeyResponse.getter(UpdateRepositoryEncryptionKeyResponse::kmsKeyId)).setter(UpdateRepositoryEncryptionKeyResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> ORIGINAL_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originalKmsKeyId").getter(UpdateRepositoryEncryptionKeyResponse.getter(UpdateRepositoryEncryptionKeyResponse::originalKmsKeyId)).setter(UpdateRepositoryEncryptionKeyResponse.setter(Builder::originalKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originalKmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ID_FIELD, KMS_KEY_ID_FIELD, ORIGINAL_KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRepositoryEncryptionKeyResponse.memberNameToFieldInitializer();
    private final String repositoryId;
    private final String kmsKeyId;
    private final String originalKmsKeyId;

    private UpdateRepositoryEncryptionKeyResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryId = builder.repositoryId;
        this.kmsKeyId = builder.kmsKeyId;
        this.originalKmsKeyId = builder.originalKmsKeyId;
    }

    public final String repositoryId() {
        return this.repositoryId;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String originalKmsKeyId() {
        return this.originalKmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalKmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRepositoryEncryptionKeyResponse)) {
            return false;
        }
        UpdateRepositoryEncryptionKeyResponse other = (UpdateRepositoryEncryptionKeyResponse)((Object)obj);
        return Objects.equals(this.repositoryId(), other.repositoryId()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.originalKmsKeyId(), other.originalKmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRepositoryEncryptionKeyResponse").add("RepositoryId", (Object)this.repositoryId()).add("KmsKeyId", (Object)this.kmsKeyId()).add("OriginalKmsKeyId", (Object)this.originalKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryId": {
                return Optional.ofNullable(clazz.cast(this.repositoryId()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "originalKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.originalKmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("repositoryId", REPOSITORY_ID_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("originalKmsKeyId", ORIGINAL_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRepositoryEncryptionKeyResponse, T> g) {
        return obj -> g.apply((UpdateRepositoryEncryptionKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private String repositoryId;
        private String kmsKeyId;
        private String originalKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRepositoryEncryptionKeyResponse model) {
            super(model);
            this.repositoryId(model.repositoryId);
            this.kmsKeyId(model.kmsKeyId);
            this.originalKmsKeyId(model.originalKmsKeyId);
        }

        public final String getRepositoryId() {
            return this.repositoryId;
        }

        public final void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Override
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getOriginalKmsKeyId() {
            return this.originalKmsKeyId;
        }

        public final void setOriginalKmsKeyId(String originalKmsKeyId) {
            this.originalKmsKeyId = originalKmsKeyId;
        }

        @Override
        public final Builder originalKmsKeyId(String originalKmsKeyId) {
            this.originalKmsKeyId = originalKmsKeyId;
            return this;
        }

        @Override
        public UpdateRepositoryEncryptionKeyResponse build() {
            return new UpdateRepositoryEncryptionKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRepositoryEncryptionKeyResponse> {
        public Builder repositoryId(String var1);

        public Builder kmsKeyId(String var1);

        public Builder originalKmsKeyId(String var1);
    }
}

