/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstanceAction {
    TERMINATE("TERMINATE"),
    KEEP_ALIVE("KEEP_ALIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceAction.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceAction> knownValues() {
        return Stream.of(InstanceAction.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

