/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsClient;
import software.amazon.awssdk.services.codestarconnections.internal.UserAgentUtils;
import software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsRequest;
import software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsResponse;

public class ListSyncConfigurationsIterable
implements SdkIterable<ListSyncConfigurationsResponse> {
    private final CodeStarConnectionsClient client;
    private final ListSyncConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSyncConfigurationsIterable(CodeStarConnectionsClient client, ListSyncConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSyncConfigurationsResponseFetcher();
    }

    public Iterator<ListSyncConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSyncConfigurationsResponseFetcher
    implements SyncPageFetcher<ListSyncConfigurationsResponse> {
        private ListSyncConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSyncConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSyncConfigurationsResponse nextPage(ListSyncConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListSyncConfigurationsIterable.this.client.listSyncConfigurations(ListSyncConfigurationsIterable.this.firstRequest);
            }
            return ListSyncConfigurationsIterable.this.client.listSyncConfigurations((ListSyncConfigurationsRequest)((Object)ListSyncConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

