/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityAsyncClient;
import software.amazon.awssdk.services.cognitoidentity.internal.UserAgentUtils;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse;

public class ListIdentityPoolsPublisher
implements SdkPublisher<ListIdentityPoolsResponse> {
    private final CognitoIdentityAsyncClient client;
    private final ListIdentityPoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdentityPoolsPublisher(CognitoIdentityAsyncClient client, ListIdentityPoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdentityPoolsPublisher(CognitoIdentityAsyncClient client, ListIdentityPoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdentityPoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdentityPoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IdentityPoolShortDescription> identityPools() {
        Function<ListIdentityPoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.identityPools() != null) {
                return response.identityPools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIdentityPoolsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIdentityPoolsResponseFetcher
    implements AsyncPageFetcher<ListIdentityPoolsResponse> {
        private ListIdentityPoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentityPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdentityPoolsResponse> nextPage(ListIdentityPoolsResponse previousPage) {
            if (previousPage == null) {
                return ListIdentityPoolsPublisher.this.client.listIdentityPools(ListIdentityPoolsPublisher.this.firstRequest);
            }
            return ListIdentityPoolsPublisher.this.client.listIdentityPools((ListIdentityPoolsRequest)((Object)ListIdentityPoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

