/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeManagedLoginBrandingRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, DescribeManagedLoginBrandingRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(DescribeManagedLoginBrandingRequest.getter(DescribeManagedLoginBrandingRequest::userPoolId)).setter(DescribeManagedLoginBrandingRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> MANAGED_LOGIN_BRANDING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedLoginBrandingId").getter(DescribeManagedLoginBrandingRequest.getter(DescribeManagedLoginBrandingRequest::managedLoginBrandingId)).setter(DescribeManagedLoginBrandingRequest.setter(Builder::managedLoginBrandingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoginBrandingId").build()}).build();
    private static final SdkField<Boolean> RETURN_MERGED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReturnMergedResources").getter(DescribeManagedLoginBrandingRequest.getter(DescribeManagedLoginBrandingRequest::returnMergedResources)).setter(DescribeManagedLoginBrandingRequest.setter(Builder::returnMergedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnMergedResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, MANAGED_LOGIN_BRANDING_ID_FIELD, RETURN_MERGED_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeManagedLoginBrandingRequest.memberNameToFieldInitializer();
    private final String userPoolId;
    private final String managedLoginBrandingId;
    private final Boolean returnMergedResources;

    private DescribeManagedLoginBrandingRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.managedLoginBrandingId = builder.managedLoginBrandingId;
        this.returnMergedResources = builder.returnMergedResources;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String managedLoginBrandingId() {
        return this.managedLoginBrandingId;
    }

    public final Boolean returnMergedResources() {
        return this.returnMergedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedLoginBrandingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnMergedResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedLoginBrandingRequest)) {
            return false;
        }
        DescribeManagedLoginBrandingRequest other = (DescribeManagedLoginBrandingRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.managedLoginBrandingId(), other.managedLoginBrandingId()) && Objects.equals(this.returnMergedResources(), other.returnMergedResources());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeManagedLoginBrandingRequest").add("UserPoolId", (Object)this.userPoolId()).add("ManagedLoginBrandingId", (Object)this.managedLoginBrandingId()).add("ReturnMergedResources", (Object)this.returnMergedResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ManagedLoginBrandingId": {
                return Optional.ofNullable(clazz.cast(this.managedLoginBrandingId()));
            }
            case "ReturnMergedResources": {
                return Optional.ofNullable(clazz.cast(this.returnMergedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("ManagedLoginBrandingId", MANAGED_LOGIN_BRANDING_ID_FIELD);
        map.put("ReturnMergedResources", RETURN_MERGED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedLoginBrandingRequest, T> g) {
        return obj -> g.apply((DescribeManagedLoginBrandingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String managedLoginBrandingId;
        private Boolean returnMergedResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedLoginBrandingRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.managedLoginBrandingId(model.managedLoginBrandingId);
            this.returnMergedResources(model.returnMergedResources);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getManagedLoginBrandingId() {
            return this.managedLoginBrandingId;
        }

        public final void setManagedLoginBrandingId(String managedLoginBrandingId) {
            this.managedLoginBrandingId = managedLoginBrandingId;
        }

        @Override
        public final Builder managedLoginBrandingId(String managedLoginBrandingId) {
            this.managedLoginBrandingId = managedLoginBrandingId;
            return this;
        }

        public final Boolean getReturnMergedResources() {
            return this.returnMergedResources;
        }

        public final void setReturnMergedResources(Boolean returnMergedResources) {
            this.returnMergedResources = returnMergedResources;
        }

        @Override
        public final Builder returnMergedResources(Boolean returnMergedResources) {
            this.returnMergedResources = returnMergedResources;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeManagedLoginBrandingRequest build() {
            return new DescribeManagedLoginBrandingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeManagedLoginBrandingRequest> {
        public Builder userPoolId(String var1);

        public Builder managedLoginBrandingId(String var1);

        public Builder returnMergedResources(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

