/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserVerificationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebAuthnConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebAuthnConfigurationType> {
    private static final SdkField<String> RELYING_PARTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelyingPartyId").getter(WebAuthnConfigurationType.getter(WebAuthnConfigurationType::relyingPartyId)).setter(WebAuthnConfigurationType.setter(Builder::relyingPartyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelyingPartyId").build()}).build();
    private static final SdkField<String> USER_VERIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserVerification").getter(WebAuthnConfigurationType.getter(WebAuthnConfigurationType::userVerificationAsString)).setter(WebAuthnConfigurationType.setter(Builder::userVerification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserVerification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELYING_PARTY_ID_FIELD, USER_VERIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WebAuthnConfigurationType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String relyingPartyId;
    private final String userVerification;

    private WebAuthnConfigurationType(BuilderImpl builder) {
        this.relyingPartyId = builder.relyingPartyId;
        this.userVerification = builder.userVerification;
    }

    public final String relyingPartyId() {
        return this.relyingPartyId;
    }

    public final UserVerificationType userVerification() {
        return UserVerificationType.fromValue(this.userVerification);
    }

    public final String userVerificationAsString() {
        return this.userVerification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relyingPartyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userVerificationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebAuthnConfigurationType)) {
            return false;
        }
        WebAuthnConfigurationType other = (WebAuthnConfigurationType)obj;
        return Objects.equals(this.relyingPartyId(), other.relyingPartyId()) && Objects.equals(this.userVerificationAsString(), other.userVerificationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WebAuthnConfigurationType").add("RelyingPartyId", (Object)this.relyingPartyId()).add("UserVerification", (Object)this.userVerificationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RelyingPartyId": {
                return Optional.ofNullable(clazz.cast(this.relyingPartyId()));
            }
            case "UserVerification": {
                return Optional.ofNullable(clazz.cast(this.userVerificationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RelyingPartyId", RELYING_PARTY_ID_FIELD);
        map.put("UserVerification", USER_VERIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebAuthnConfigurationType, T> g) {
        return obj -> g.apply((WebAuthnConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String relyingPartyId;
        private String userVerification;

        private BuilderImpl() {
        }

        private BuilderImpl(WebAuthnConfigurationType model) {
            this.relyingPartyId(model.relyingPartyId);
            this.userVerification(model.userVerification);
        }

        public final String getRelyingPartyId() {
            return this.relyingPartyId;
        }

        public final void setRelyingPartyId(String relyingPartyId) {
            this.relyingPartyId = relyingPartyId;
        }

        @Override
        public final Builder relyingPartyId(String relyingPartyId) {
            this.relyingPartyId = relyingPartyId;
            return this;
        }

        public final String getUserVerification() {
            return this.userVerification;
        }

        public final void setUserVerification(String userVerification) {
            this.userVerification = userVerification;
        }

        @Override
        public final Builder userVerification(String userVerification) {
            this.userVerification = userVerification;
            return this;
        }

        @Override
        public final Builder userVerification(UserVerificationType userVerification) {
            this.userVerification(userVerification == null ? null : userVerification.toString());
            return this;
        }

        public WebAuthnConfigurationType build() {
            return new WebAuthnConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebAuthnConfigurationType> {
        public Builder relyingPartyId(String var1);

        public Builder userVerification(String var1);

        public Builder userVerification(UserVerificationType var1);
    }
}

