/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClient;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.UserAgentUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType;

public class AdminListUserAuthEventsPublisher
implements SdkPublisher<AdminListUserAuthEventsResponse> {
    private final CognitoIdentityProviderAsyncClient client;
    private final AdminListUserAuthEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public AdminListUserAuthEventsPublisher(CognitoIdentityProviderAsyncClient client, AdminListUserAuthEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private AdminListUserAuthEventsPublisher(CognitoIdentityProviderAsyncClient client, AdminListUserAuthEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new AdminListUserAuthEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super AdminListUserAuthEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuthEventType> authEvents() {
        Function<AdminListUserAuthEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.authEvents() != null) {
                return response.authEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new AdminListUserAuthEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class AdminListUserAuthEventsResponseFetcher
    implements AsyncPageFetcher<AdminListUserAuthEventsResponse> {
        private AdminListUserAuthEventsResponseFetcher() {
        }

        public boolean hasNextPage(AdminListUserAuthEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<AdminListUserAuthEventsResponse> nextPage(AdminListUserAuthEventsResponse previousPage) {
            if (previousPage == null) {
                return AdminListUserAuthEventsPublisher.this.client.adminListUserAuthEvents(AdminListUserAuthEventsPublisher.this.firstRequest);
            }
            return AdminListUserAuthEventsPublisher.this.client.adminListUserAuthEvents((AdminListUserAuthEventsRequest)((Object)AdminListUserAuthEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

