/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Organization conformance pack creation or deletion status in each member account. This includes the name of the
 * conformance pack, the status, error code and error message when the conformance pack creation or deletion failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationConformancePackDetailedStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationConformancePackDetailedStatus.Builder, OrganizationConformancePackDetailedStatus> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(OrganizationConformancePackDetailedStatus::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackName").getter(getter(OrganizationConformancePackDetailedStatus::conformancePackName))
            .setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OrganizationConformancePackDetailedStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(OrganizationConformancePackDetailedStatus::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(OrganizationConformancePackDetailedStatus::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(OrganizationConformancePackDetailedStatus::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CONFORMANCE_PACK_NAME_FIELD, STATUS_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String conformancePackName;

    private final String status;

    private final String errorCode;

    private final String errorMessage;

    private final Instant lastUpdateTime;

    private OrganizationConformancePackDetailedStatus(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.conformancePackName = builder.conformancePackName;
        this.status = builder.status;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The 12-digit account ID of a member account.
     * </p>
     * 
     * @return The 12-digit account ID of a member account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of conformance pack deployed in the member account.
     * </p>
     * 
     * @return The name of conformance pack deployed in the member account.
     */
    public final String conformancePackName() {
        return conformancePackName;
    }

    /**
     * <p>
     * Indicates deployment status for conformance pack in a member account. When master account calls
     * <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the
     * member account. When master account calls <code>PutOrganizationConformancePack</code> action for the second time,
     * conformance pack status is updated in the member account. Conformance pack status is deleted when the master
     * account deletes <code>OrganizationConformancePack</code> and disables service access for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * Config sets the state of the conformance pack to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationResourceDetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates deployment status for conformance pack in a member account. When master account calls
     *         <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created
     *         in the member account. When master account calls <code>PutOrganizationConformancePack</code> action for
     *         the second time, conformance pack status is updated in the member account. Conformance pack status is
     *         deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service
     *         access for <code>config-multiaccountsetup.amazonaws.com</code>. </p>
     *         <p>
     *         Config sets the state of the conformance pack to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
     *         </p>
     *         </li>
     * @see OrganizationResourceDetailedStatus
     */
    public final OrganizationResourceDetailedStatus status() {
        return OrganizationResourceDetailedStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates deployment status for conformance pack in a member account. When master account calls
     * <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the
     * member account. When master account calls <code>PutOrganizationConformancePack</code> action for the second time,
     * conformance pack status is updated in the member account. Conformance pack status is deleted when the master
     * account deletes <code>OrganizationConformancePack</code> and disables service access for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * Config sets the state of the conformance pack to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationResourceDetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates deployment status for conformance pack in a member account. When master account calls
     *         <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created
     *         in the member account. When master account calls <code>PutOrganizationConformancePack</code> action for
     *         the second time, conformance pack status is updated in the member account. Conformance pack status is
     *         deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service
     *         access for <code>config-multiaccountsetup.amazonaws.com</code>. </p>
     *         <p>
     *         Config sets the state of the conformance pack to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
     *         </p>
     *         </li>
     * @see OrganizationResourceDetailedStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An error code that is returned when conformance pack creation or deletion failed in the member account.
     * </p>
     * 
     * @return An error code that is returned when conformance pack creation or deletion failed in the member account.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * An error message indicating that conformance pack account creation or deletion has failed due to an error in the
     * member account.
     * </p>
     * 
     * @return An error message indicating that conformance pack account creation or deletion has failed due to an error
     *         in the member account.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The timestamp of the last status update.
     * </p>
     * 
     * @return The timestamp of the last status update.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConformancePackDetailedStatus)) {
            return false;
        }
        OrganizationConformancePackDetailedStatus other = (OrganizationConformancePackDetailedStatus) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(conformancePackName(), other.conformancePackName())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationConformancePackDetailedStatus").add("AccountId", accountId())
                .add("ConformancePackName", conformancePackName()).add("Status", statusAsString()).add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConformancePackDetailedStatus, T> g) {
        return obj -> g.apply((OrganizationConformancePackDetailedStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationConformancePackDetailedStatus> {
        /**
         * <p>
         * The 12-digit account ID of a member account.
         * </p>
         * 
         * @param accountId
         *        The 12-digit account ID of a member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of conformance pack deployed in the member account.
         * </p>
         * 
         * @param conformancePackName
         *        The name of conformance pack deployed in the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * Indicates deployment status for conformance pack in a member account. When master account calls
         * <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in
         * the member account. When master account calls <code>PutOrganizationConformancePack</code> action for the
         * second time, conformance pack status is updated in the member account. Conformance pack status is deleted
         * when the master account deletes <code>OrganizationConformancePack</code> and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * Config sets the state of the conformance pack to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Indicates deployment status for conformance pack in a member account. When master account calls
         *        <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is
         *        created in the member account. When master account calls <code>PutOrganizationConformancePack</code>
         *        action for the second time, conformance pack status is updated in the member account. Conformance pack
         *        status is deleted when the master account deletes <code>OrganizationConformancePack</code> and
         *        disables service access for <code>config-multiaccountsetup.amazonaws.com</code>. </p>
         *        <p>
         *        Config sets the state of the conformance pack to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
         *        </p>
         *        </li>
         * @see OrganizationResourceDetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationResourceDetailedStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates deployment status for conformance pack in a member account. When master account calls
         * <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in
         * the member account. When master account calls <code>PutOrganizationConformancePack</code> action for the
         * second time, conformance pack status is updated in the member account. Conformance pack status is deleted
         * when the master account deletes <code>OrganizationConformancePack</code> and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * Config sets the state of the conformance pack to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Indicates deployment status for conformance pack in a member account. When master account calls
         *        <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is
         *        created in the member account. When master account calls <code>PutOrganizationConformancePack</code>
         *        action for the second time, conformance pack status is updated in the member account. Conformance pack
         *        status is deleted when the master account deletes <code>OrganizationConformancePack</code> and
         *        disables service access for <code>config-multiaccountsetup.amazonaws.com</code>. </p>
         *        <p>
         *        Config sets the state of the conformance pack to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
         *        </p>
         *        </li>
         * @see OrganizationResourceDetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationResourceDetailedStatus
         */
        Builder status(OrganizationResourceDetailedStatus status);

        /**
         * <p>
         * An error code that is returned when conformance pack creation or deletion failed in the member account.
         * </p>
         * 
         * @param errorCode
         *        An error code that is returned when conformance pack creation or deletion failed in the member
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * An error message indicating that conformance pack account creation or deletion has failed due to an error in
         * the member account.
         * </p>
         * 
         * @param errorMessage
         *        An error message indicating that conformance pack account creation or deletion has failed due to an
         *        error in the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The timestamp of the last status update.
         * </p>
         * 
         * @param lastUpdateTime
         *        The timestamp of the last status update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String conformancePackName;

        private String status;

        private String errorCode;

        private String errorMessage;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConformancePackDetailedStatus model) {
            accountId(model.accountId);
            conformancePackName(model.conformancePackName);
            status(model.status);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrganizationResourceDetailedStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public OrganizationConformancePackDetailedStatus build() {
            return new OrganizationConformancePackDetailedStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
