/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information for score and potential quality issues for Audio
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioQualityMetricsInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioQualityMetricsInfo.Builder, AudioQualityMetricsInfo> {
    private static final SdkField<Float> QUALITY_SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("QualityScore").getter(getter(AudioQualityMetricsInfo::qualityScore))
            .setter(setter(Builder::qualityScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityScore").build()).build();

    private static final SdkField<List<String>> POTENTIAL_QUALITY_ISSUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PotentialQualityIssues")
            .getter(getter(AudioQualityMetricsInfo::potentialQualityIssues))
            .setter(setter(Builder::potentialQualityIssues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PotentialQualityIssues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALITY_SCORE_FIELD,
            POTENTIAL_QUALITY_ISSUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float qualityScore;

    private final List<String> potentialQualityIssues;

    private AudioQualityMetricsInfo(BuilderImpl builder) {
        this.qualityScore = builder.qualityScore;
        this.potentialQualityIssues = builder.potentialQualityIssues;
    }

    /**
     * <p>
     * Number measuring the estimated quality of the media connection.
     * </p>
     * 
     * @return Number measuring the estimated quality of the media connection.
     */
    public final Float qualityScore() {
        return qualityScore;
    }

    /**
     * For responses, this returns true if the service returned a value for the PotentialQualityIssues property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPotentialQualityIssues() {
        return potentialQualityIssues != null && !(potentialQualityIssues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of potential issues causing degradation of quality on a media connection. If the service did not detect any
     * potential quality issues the list is empty.
     * </p>
     * <p>
     * Valid values: <code>HighPacketLoss</code> | <code>HighRoundTripTime</code> | <code>HighJitterBuffer</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPotentialQualityIssues} method.
     * </p>
     * 
     * @return List of potential issues causing degradation of quality on a media connection. If the service did not
     *         detect any potential quality issues the list is empty.</p>
     *         <p>
     *         Valid values: <code>HighPacketLoss</code> | <code>HighRoundTripTime</code> |
     *         <code>HighJitterBuffer</code>
     */
    public final List<String> potentialQualityIssues() {
        return potentialQualityIssues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qualityScore());
        hashCode = 31 * hashCode + Objects.hashCode(hasPotentialQualityIssues() ? potentialQualityIssues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioQualityMetricsInfo)) {
            return false;
        }
        AudioQualityMetricsInfo other = (AudioQualityMetricsInfo) obj;
        return Objects.equals(qualityScore(), other.qualityScore())
                && hasPotentialQualityIssues() == other.hasPotentialQualityIssues()
                && Objects.equals(potentialQualityIssues(), other.potentialQualityIssues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioQualityMetricsInfo").add("QualityScore", qualityScore())
                .add("PotentialQualityIssues", hasPotentialQualityIssues() ? potentialQualityIssues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QualityScore":
            return Optional.ofNullable(clazz.cast(qualityScore()));
        case "PotentialQualityIssues":
            return Optional.ofNullable(clazz.cast(potentialQualityIssues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioQualityMetricsInfo, T> g) {
        return obj -> g.apply((AudioQualityMetricsInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioQualityMetricsInfo> {
        /**
         * <p>
         * Number measuring the estimated quality of the media connection.
         * </p>
         * 
         * @param qualityScore
         *        Number measuring the estimated quality of the media connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualityScore(Float qualityScore);

        /**
         * <p>
         * List of potential issues causing degradation of quality on a media connection. If the service did not detect
         * any potential quality issues the list is empty.
         * </p>
         * <p>
         * Valid values: <code>HighPacketLoss</code> | <code>HighRoundTripTime</code> | <code>HighJitterBuffer</code>
         * </p>
         * 
         * @param potentialQualityIssues
         *        List of potential issues causing degradation of quality on a media connection. If the service did not
         *        detect any potential quality issues the list is empty.</p>
         *        <p>
         *        Valid values: <code>HighPacketLoss</code> | <code>HighRoundTripTime</code> |
         *        <code>HighJitterBuffer</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder potentialQualityIssues(Collection<String> potentialQualityIssues);

        /**
         * <p>
         * List of potential issues causing degradation of quality on a media connection. If the service did not detect
         * any potential quality issues the list is empty.
         * </p>
         * <p>
         * Valid values: <code>HighPacketLoss</code> | <code>HighRoundTripTime</code> | <code>HighJitterBuffer</code>
         * </p>
         * 
         * @param potentialQualityIssues
         *        List of potential issues causing degradation of quality on a media connection. If the service did not
         *        detect any potential quality issues the list is empty.</p>
         *        <p>
         *        Valid values: <code>HighPacketLoss</code> | <code>HighRoundTripTime</code> |
         *        <code>HighJitterBuffer</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder potentialQualityIssues(String... potentialQualityIssues);
    }

    static final class BuilderImpl implements Builder {
        private Float qualityScore;

        private List<String> potentialQualityIssues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioQualityMetricsInfo model) {
            qualityScore(model.qualityScore);
            potentialQualityIssues(model.potentialQualityIssues);
        }

        public final Float getQualityScore() {
            return qualityScore;
        }

        public final void setQualityScore(Float qualityScore) {
            this.qualityScore = qualityScore;
        }

        @Override
        public final Builder qualityScore(Float qualityScore) {
            this.qualityScore = qualityScore;
            return this;
        }

        public final Collection<String> getPotentialQualityIssues() {
            if (potentialQualityIssues instanceof SdkAutoConstructList) {
                return null;
            }
            return potentialQualityIssues;
        }

        public final void setPotentialQualityIssues(Collection<String> potentialQualityIssues) {
            this.potentialQualityIssues = PotentialAudioQualityIssuesCopier.copy(potentialQualityIssues);
        }

        @Override
        public final Builder potentialQualityIssues(Collection<String> potentialQualityIssues) {
            this.potentialQualityIssues = PotentialAudioQualityIssuesCopier.copy(potentialQualityIssues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder potentialQualityIssues(String... potentialQualityIssues) {
            potentialQualityIssues(Arrays.asList(potentialQualityIssues));
            return this;
        }

        @Override
        public AudioQualityMetricsInfo build() {
            return new AudioQualityMetricsInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
