/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object to store union of Field values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldValueUnion implements SdkPojo, Serializable, ToCopyableBuilder<FieldValueUnion.Builder, FieldValueUnion> {
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BooleanValue").getter(getter(FieldValueUnion::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DoubleValue").getter(getter(FieldValueUnion::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleValue").build()).build();

    private static final SdkField<EmptyFieldValue> EMPTY_VALUE_FIELD = SdkField
            .<EmptyFieldValue> builder(MarshallingType.SDK_POJO).memberName("EmptyValue")
            .getter(getter(FieldValueUnion::emptyValue)).setter(setter(Builder::emptyValue))
            .constructor(EmptyFieldValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmptyValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StringValue").getter(getter(FieldValueUnion::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_VALUE_FIELD,
            DOUBLE_VALUE_FIELD, EMPTY_VALUE_FIELD, STRING_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean booleanValue;

    private final Double doubleValue;

    private final EmptyFieldValue emptyValue;

    private final String stringValue;

    private FieldValueUnion(BuilderImpl builder) {
        this.booleanValue = builder.booleanValue;
        this.doubleValue = builder.doubleValue;
        this.emptyValue = builder.emptyValue;
        this.stringValue = builder.stringValue;
    }

    /**
     * <p>
     * A Boolean number value type.
     * </p>
     * 
     * @return A Boolean number value type.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * A Double number value type.
     * </p>
     * 
     * @return A Double number value type.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * An empty value.
     * </p>
     * 
     * @return An empty value.
     */
    public final EmptyFieldValue emptyValue() {
        return emptyValue;
    }

    /**
     * <p>
     * String value type.
     * </p>
     * 
     * @return String value type.
     */
    public final String stringValue() {
        return stringValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(emptyValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldValueUnion)) {
            return false;
        }
        FieldValueUnion other = (FieldValueUnion) obj;
        return Objects.equals(booleanValue(), other.booleanValue()) && Objects.equals(doubleValue(), other.doubleValue())
                && Objects.equals(emptyValue(), other.emptyValue()) && Objects.equals(stringValue(), other.stringValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldValueUnion").add("BooleanValue", booleanValue()).add("DoubleValue", doubleValue())
                .add("EmptyValue", emptyValue()).add("StringValue", stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BooleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "DoubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "EmptyValue":
            return Optional.ofNullable(clazz.cast(emptyValue()));
        case "StringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldValueUnion, T> g) {
        return obj -> g.apply((FieldValueUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldValueUnion> {
        /**
         * <p>
         * A Boolean number value type.
         * </p>
         * 
         * @param booleanValue
         *        A Boolean number value type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * A Double number value type.
         * </p>
         * 
         * @param doubleValue
         *        A Double number value type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * An empty value.
         * </p>
         * 
         * @param emptyValue
         *        An empty value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emptyValue(EmptyFieldValue emptyValue);

        /**
         * <p>
         * An empty value.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmptyFieldValue.Builder} avoiding the
         * need to create one manually via {@link EmptyFieldValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmptyFieldValue.Builder#build()} is called immediately and its
         * result is passed to {@link #emptyValue(EmptyFieldValue)}.
         * 
         * @param emptyValue
         *        a consumer that will call methods on {@link EmptyFieldValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emptyValue(EmptyFieldValue)
         */
        default Builder emptyValue(Consumer<EmptyFieldValue.Builder> emptyValue) {
            return emptyValue(EmptyFieldValue.builder().applyMutation(emptyValue).build());
        }

        /**
         * <p>
         * String value type.
         * </p>
         * 
         * @param stringValue
         *        String value type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);
    }

    static final class BuilderImpl implements Builder {
        private Boolean booleanValue;

        private Double doubleValue;

        private EmptyFieldValue emptyValue;

        private String stringValue;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldValueUnion model) {
            booleanValue(model.booleanValue);
            doubleValue(model.doubleValue);
            emptyValue(model.emptyValue);
            stringValue(model.stringValue);
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final EmptyFieldValue.Builder getEmptyValue() {
            return emptyValue != null ? emptyValue.toBuilder() : null;
        }

        public final void setEmptyValue(EmptyFieldValue.BuilderImpl emptyValue) {
            this.emptyValue = emptyValue != null ? emptyValue.build() : null;
        }

        @Override
        public final Builder emptyValue(EmptyFieldValue emptyValue) {
            this.emptyValue = emptyValue;
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        @Override
        public FieldValueUnion build() {
            return new FieldValueUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
