/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about values of a predefined attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredefinedAttributeValues implements SdkPojo, Serializable,
        ToCopyableBuilder<PredefinedAttributeValues.Builder, PredefinedAttributeValues> {
    private static final SdkField<List<String>> STRING_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StringList")
            .getter(getter(PredefinedAttributeValues::stringList))
            .setter(setter(Builder::stringList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> stringList;

    private final Type type;

    private PredefinedAttributeValues(BuilderImpl builder) {
        this.stringList = builder.stringList;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStringList() {
        return stringList != null && !(stringList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Predefined attribute values of type string list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringList} method.
     * </p>
     * 
     * @return Predefined attribute values of type string list.
     */
    public final List<String> stringList() {
        return stringList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStringList() ? stringList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedAttributeValues)) {
            return false;
        }
        PredefinedAttributeValues other = (PredefinedAttributeValues) obj;
        return hasStringList() == other.hasStringList() && Objects.equals(stringList(), other.stringList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredefinedAttributeValues").add("StringList", hasStringList() ? stringList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringList":
            return Optional.ofNullable(clazz.cast(stringList()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #stringList()} initialized to the given value.
     *
     * <p>
     * Predefined attribute values of type string list.
     * </p>
     * 
     * @param stringList
     *        Predefined attribute values of type string list.
     */
    public static PredefinedAttributeValues fromStringList(List<String> stringList) {
        return builder().stringList(stringList).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredefinedAttributeValues, T> g) {
        return obj -> g.apply((PredefinedAttributeValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredefinedAttributeValues> {
        /**
         * <p>
         * Predefined attribute values of type string list.
         * </p>
         * 
         * @param stringList
         *        Predefined attribute values of type string list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringList(Collection<String> stringList);

        /**
         * <p>
         * Predefined attribute values of type string list.
         * </p>
         * 
         * @param stringList
         *        Predefined attribute values of type string list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringList(String... stringList);
    }

    static final class BuilderImpl implements Builder {
        private List<String> stringList = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedAttributeValues model) {
            stringList(model.stringList);
        }

        public final Collection<String> getStringList() {
            if (stringList instanceof SdkAutoConstructList) {
                return null;
            }
            return stringList;
        }

        public final void setStringList(Collection<String> stringList) {
            Object oldValue = this.stringList;
            this.stringList = PredefinedAttributeStringValuesListCopier.copy(stringList);
            handleUnionValueChange(Type.STRING_LIST, oldValue, this.stringList);
        }

        @Override
        public final Builder stringList(Collection<String> stringList) {
            Object oldValue = this.stringList;
            this.stringList = PredefinedAttributeStringValuesListCopier.copy(stringList);
            handleUnionValueChange(Type.STRING_LIST, oldValue, this.stringList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringList(String... stringList) {
            stringList(Arrays.asList(stringList));
            return this;
        }

        @Override
        public PredefinedAttributeValues build() {
            return new PredefinedAttributeValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PredefinedAttributeValues#type()
     */
    public enum Type {
        STRING_LIST,

        UNKNOWN_TO_SDK_VERSION
    }
}
