/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchContactFlowsRequest extends ConnectRequest implements
        ToCopyableBuilder<SearchContactFlowsRequest.Builder, SearchContactFlowsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SearchContactFlowsRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchContactFlowsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchContactFlowsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<ContactFlowSearchFilter> SEARCH_FILTER_FIELD = SdkField
            .<ContactFlowSearchFilter> builder(MarshallingType.SDK_POJO).memberName("SearchFilter")
            .getter(getter(SearchContactFlowsRequest::searchFilter)).setter(setter(Builder::searchFilter))
            .constructor(ContactFlowSearchFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchFilter").build()).build();

    private static final SdkField<ContactFlowSearchCriteria> SEARCH_CRITERIA_FIELD = SdkField
            .<ContactFlowSearchCriteria> builder(MarshallingType.SDK_POJO).memberName("SearchCriteria")
            .getter(getter(SearchContactFlowsRequest::searchCriteria)).setter(setter(Builder::searchCriteria))
            .constructor(ContactFlowSearchCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SEARCH_FILTER_FIELD, SEARCH_CRITERIA_FIELD));

    private final String instanceId;

    private final String nextToken;

    private final Integer maxResults;

    private final ContactFlowSearchFilter searchFilter;

    private final ContactFlowSearchCriteria searchCriteria;

    private SearchContactFlowsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.searchFilter = builder.searchFilter;
        this.searchCriteria = builder.searchCriteria;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of
     * the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name
     *         (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filters to be applied to search results.
     * </p>
     * 
     * @return Filters to be applied to search results.
     */
    public final ContactFlowSearchFilter searchFilter() {
        return searchFilter;
    }

    /**
     * <p>
     * The search criteria to be used to return flows.
     * </p>
     * <note>
     * <p>
     * The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2
     * characters and a maximum of 25 characters. Any queries with character lengths outside of this range will result
     * in invalid results.
     * </p>
     * </note>
     * 
     * @return The search criteria to be used to return flows.</p> <note>
     *         <p>
     *         The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2
     *         characters and a maximum of 25 characters. Any queries with character lengths outside of this range will
     *         result in invalid results.
     *         </p>
     */
    public final ContactFlowSearchCriteria searchCriteria() {
        return searchCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(searchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(searchCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactFlowsRequest)) {
            return false;
        }
        SearchContactFlowsRequest other = (SearchContactFlowsRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(searchFilter(), other.searchFilter())
                && Objects.equals(searchCriteria(), other.searchCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchContactFlowsRequest").add("InstanceId", instanceId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("SearchFilter", searchFilter()).add("SearchCriteria", searchCriteria())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SearchFilter":
            return Optional.ofNullable(clazz.cast(searchFilter()));
        case "SearchCriteria":
            return Optional.ofNullable(clazz.cast(searchCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchContactFlowsRequest, T> g) {
        return obj -> g.apply((SearchContactFlowsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchContactFlowsRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN)
         * of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource
         *        Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters to be applied to search results.
         * </p>
         * 
         * @param searchFilter
         *        Filters to be applied to search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchFilter(ContactFlowSearchFilter searchFilter);

        /**
         * <p>
         * Filters to be applied to search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactFlowSearchFilter.Builder} avoiding
         * the need to create one manually via {@link ContactFlowSearchFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactFlowSearchFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #searchFilter(ContactFlowSearchFilter)}.
         * 
         * @param searchFilter
         *        a consumer that will call methods on {@link ContactFlowSearchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchFilter(ContactFlowSearchFilter)
         */
        default Builder searchFilter(Consumer<ContactFlowSearchFilter.Builder> searchFilter) {
            return searchFilter(ContactFlowSearchFilter.builder().applyMutation(searchFilter).build());
        }

        /**
         * <p>
         * The search criteria to be used to return flows.
         * </p>
         * <note>
         * <p>
         * The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2
         * characters and a maximum of 25 characters. Any queries with character lengths outside of this range will
         * result in invalid results.
         * </p>
         * </note>
         * 
         * @param searchCriteria
         *        The search criteria to be used to return flows.</p> <note>
         *        <p>
         *        The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of
         *        2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range
         *        will result in invalid results.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchCriteria(ContactFlowSearchCriteria searchCriteria);

        /**
         * <p>
         * The search criteria to be used to return flows.
         * </p>
         * <note>
         * <p>
         * The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2
         * characters and a maximum of 25 characters. Any queries with character lengths outside of this range will
         * result in invalid results.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link ContactFlowSearchCriteria.Builder} avoiding the need to create one manually via
         * {@link ContactFlowSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactFlowSearchCriteria.Builder#build()} is called immediately
         * and its result is passed to {@link #searchCriteria(ContactFlowSearchCriteria)}.
         * 
         * @param searchCriteria
         *        a consumer that will call methods on {@link ContactFlowSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchCriteria(ContactFlowSearchCriteria)
         */
        default Builder searchCriteria(Consumer<ContactFlowSearchCriteria.Builder> searchCriteria) {
            return searchCriteria(ContactFlowSearchCriteria.builder().applyMutation(searchCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String nextToken;

        private Integer maxResults;

        private ContactFlowSearchFilter searchFilter;

        private ContactFlowSearchCriteria searchCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactFlowsRequest model) {
            super(model);
            instanceId(model.instanceId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            searchFilter(model.searchFilter);
            searchCriteria(model.searchCriteria);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ContactFlowSearchFilter.Builder getSearchFilter() {
            return searchFilter != null ? searchFilter.toBuilder() : null;
        }

        public final void setSearchFilter(ContactFlowSearchFilter.BuilderImpl searchFilter) {
            this.searchFilter = searchFilter != null ? searchFilter.build() : null;
        }

        @Override
        public final Builder searchFilter(ContactFlowSearchFilter searchFilter) {
            this.searchFilter = searchFilter;
            return this;
        }

        public final ContactFlowSearchCriteria.Builder getSearchCriteria() {
            return searchCriteria != null ? searchCriteria.toBuilder() : null;
        }

        public final void setSearchCriteria(ContactFlowSearchCriteria.BuilderImpl searchCriteria) {
            this.searchCriteria = searchCriteria != null ? searchCriteria.build() : null;
        }

        @Override
        public final Builder searchCriteria(ContactFlowSearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchContactFlowsRequest build() {
            return new SearchContactFlowsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
