/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchContactsResponse extends ConnectResponse implements
        ToCopyableBuilder<SearchContactsResponse.Builder, SearchContactsResponse> {
    private static final SdkField<List<ContactSearchSummary>> CONTACTS_FIELD = SdkField
            .<List<ContactSearchSummary>> builder(MarshallingType.LIST)
            .memberName("Contacts")
            .getter(getter(SearchContactsResponse::contacts))
            .setter(setter(Builder::contacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactSearchSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactSearchSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchContactsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalCount").getter(getter(SearchContactsResponse::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACTS_FIELD,
            NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));

    private final List<ContactSearchSummary> contacts;

    private final String nextToken;

    private final Long totalCount;

    private SearchContactsResponse(BuilderImpl builder) {
        super(builder);
        this.contacts = builder.contacts;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contacts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContacts() {
        return contacts != null && !(contacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the contacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContacts} method.
     * </p>
     * 
     * @return Information about the contacts.
     */
    public final List<ContactSearchSummary> contacts() {
        return contacts;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of contacts which matched your search query.
     * </p>
     * 
     * @return The total number of contacts which matched your search query.
     */
    public final Long totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContacts() ? contacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactsResponse)) {
            return false;
        }
        SearchContactsResponse other = (SearchContactsResponse) obj;
        return hasContacts() == other.hasContacts() && Objects.equals(contacts(), other.contacts())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchContactsResponse").add("Contacts", hasContacts() ? contacts() : null)
                .add("NextToken", nextToken()).add("TotalCount", totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Contacts":
            return Optional.ofNullable(clazz.cast(contacts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchContactsResponse, T> g) {
        return obj -> g.apply((SearchContactsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchContactsResponse> {
        /**
         * <p>
         * Information about the contacts.
         * </p>
         * 
         * @param contacts
         *        Information about the contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Collection<ContactSearchSummary> contacts);

        /**
         * <p>
         * Information about the contacts.
         * </p>
         * 
         * @param contacts
         *        Information about the contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(ContactSearchSummary... contacts);

        /**
         * <p>
         * Information about the contacts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ContactSearchSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connect.model.ContactSearchSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ContactSearchSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #contacts(List<ContactSearchSummary>)}.
         * 
         * @param contacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ContactSearchSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contacts(java.util.Collection<ContactSearchSummary>)
         */
        Builder contacts(Consumer<ContactSearchSummary.Builder>... contacts);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of contacts which matched your search query.
         * </p>
         * 
         * @param totalCount
         *        The total number of contacts which matched your search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Long totalCount);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<ContactSearchSummary> contacts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactsResponse model) {
            super(model);
            contacts(model.contacts);
            nextToken(model.nextToken);
            totalCount(model.totalCount);
        }

        public final List<ContactSearchSummary.Builder> getContacts() {
            List<ContactSearchSummary.Builder> result = ContactsCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<ContactSearchSummary.BuilderImpl> contacts) {
            this.contacts = ContactsCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<ContactSearchSummary> contacts) {
            this.contacts = ContactsCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(ContactSearchSummary... contacts) {
            contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<ContactSearchSummary.Builder>... contacts) {
            contacts(Stream.of(contacts).map(c -> ContactSearchSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public SearchContactsResponse build() {
            return new SearchContactsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
